/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FabricMCRuntimeErrorProvidedBy
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> modIdsProblematicos = new HashSet<String>();
    private final Map<String, String> enlacesPorModId = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!linea.contains("Could not execute entrypoint stage") || !linea.contains("provided by")) {
            return;
        }
        try {
            int endIndex;
            int startIndex = linea.indexOf("provided by '");
            if (startIndex >= 0 && (endIndex = linea.indexOf(39, startIndex += "provided by '".length())) > startIndex) {
                String modId = linea.substring(startIndex, endIndex);
                if (this.modIdsProblematicos.add(modId)) {
                    String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                    this.enlacesPorModId.put(modId, enlace);
                }
                this.activado = true;
            }
        }
        catch (Exception e) {
            consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new FabricMCRuntimeErrorProvidedBy();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        if (this.modIdsProblematicos.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (String modId : this.modIdsProblematicos) {
            String enlace = this.enlacesPorModId.getOrDefault(modId, "");
            html.append("<li>").append(MonitorDePID.idioma.modids_problematicos()).append(" <b>").append(modId).append("</b> ").append(enlace).append("</li>").append("<br>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_fabricmc_runtime_error_provided_by();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "fabricmc_runtime_error_providedby";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!t.contains("Could not execute entrypoint stage") || !t.contains("provided by")) {
            return false;
        }
        for (String modId : this.modIdsProblematicos) {
            String fragmento = "provided by '" + modId + "'";
            if (!t.contains(fragmento)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

