/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FaltasDependenciasModLaunche
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> errores = new HashSet<String>();
    private final Map<String, String> enlacesPorError = new HashMap<String, String>();
    private String[] lineasConsola = null;

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        String lineaActual;
        if (this.lineasConsola == null) {
            this.lineasConsola = consola.contenido_verificar.split(Verificaciones.nl);
        }
        if ((lineaActual = linea.trim()).contains("only supports") && lineaActual.contains("or above") && lineaActual.contains(".Remove ")) {
            this.procesarFormatoEspecial(consola, lineaActual, numero_de_linea);
            return;
        }
        if (lineaActual.startsWith("-- MOD ") && lineaActual.endsWith(" --")) {
            return;
        }
        if (lineaActual.contains("Failure message: Mod ") && (lineaActual.contains(" requires ") || lineaActual.contains(" only supports "))) {
            this.procesarNuevoFormatoDependencia(consola, lineaActual, numero_de_linea);
            return;
        }
        if (lineaActual.contains("Missing or unsupported mandatory dependencies:")) {
            String lineaDep;
            int i = numero_de_linea;
            for (int j = i + 1; j < this.lineasConsola.length && !(lineaDep = this.lineasConsola[j].trim()).startsWith("Currently,") && !lineaDep.isEmpty(); ++j) {
                if (!lineaDep.contains("Mod ID") || !lineaDep.contains("Requested by")) continue;
                String mensaje = MonitorDePID.idioma.linea_de_dependencia(lineaDep);
                if (this.errores.add(mensaje)) {
                    String enlace = consola.agregarErrorALectador(j, this);
                    this.enlacesPorError.put(mensaje, enlace);
                }
                this.activado = true;
            }
        }
    }

    private void procesarNuevoFormatoDependencia(Consola consola, String lineaActual, int numero_de_linea) {
        try {
            if (lineaActual.contains("Remove Iris/Oculus & GeckoLib Compat")) {
                this.procesarFormatoSuperbWarfare(consola, lineaActual, numero_de_linea);
                return;
            }
            String modId = this.extraerModIdNuevoFormato(lineaActual);
            if (lineaActual.contains(",") || lineaActual.contains(" and ")) {
                List<String[]> dependencias = this.extraerMultiplesDependencias(lineaActual);
                for (String[] dependenciaInfo : dependencias) {
                    String mensaje;
                    String dependencia = dependenciaInfo[0];
                    String versionRequerida = dependenciaInfo[1];
                    String versionActual = "no encontrada";
                    for (int i = 1; i <= 3; ++i) {
                        String lineaSiguiente;
                        if (numero_de_linea + i >= this.lineasConsola.length || !(lineaSiguiente = this.lineasConsola[numero_de_linea + i].trim()).startsWith("Currently,") || !lineaSiguiente.contains(dependencia)) continue;
                        versionActual = this.extraerVersionActualNuevoFormato(lineaSiguiente);
                        break;
                    }
                    if (!this.errores.add(mensaje = versionRequerida.isEmpty() || versionRequerida.equals("any") ? MonitorDePID.idioma.errorDependenciaSimple(modId, dependencia, versionActual) : (versionActual.contains("not installed") ? MonitorDePID.idioma.errorDependenciaNoInstalada(modId, dependencia, versionRequerida) : MonitorDePID.idioma.errorVersionDependencia(modId, dependencia, versionRequerida, versionActual)))) continue;
                    String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                    this.enlacesPorError.put(mensaje, enlace);
                    this.activado = true;
                }
            } else {
                String mensaje;
                String dependencia = this.extraerDependenciaNuevoFormato(lineaActual);
                String versionRequerida = this.extraerVersionRequeridaNuevoFormato(lineaActual);
                String versionActual = "no encontrada";
                for (int i = 1; i <= 3; ++i) {
                    String lineaSiguiente;
                    if (numero_de_linea + i >= this.lineasConsola.length || !(lineaSiguiente = this.lineasConsola[numero_de_linea + i].trim()).startsWith("Currently,")) continue;
                    versionActual = this.extraerVersionActualNuevoFormato(lineaSiguiente);
                    break;
                }
                if (this.errores.add(mensaje = versionRequerida.isEmpty() || versionRequerida.equals("any") ? MonitorDePID.idioma.errorDependenciaSimple(modId, dependencia, versionActual) : (versionActual.contains("not installed") ? MonitorDePID.idioma.errorDependenciaNoInstalada(modId, dependencia, versionRequerida) : MonitorDePID.idioma.errorVersionDependencia(modId, dependencia, versionRequerida, versionActual)))) {
                    String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                    this.enlacesPorError.put(mensaje, enlace);
                    this.activado = true;
                }
            }
        }
        catch (Exception e) {
            consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    private void procesarFormatoSuperbWarfare(Consola consola, String lineaActual, int numero_de_linea) {
        try {
            String mensaje;
            String modId = "superbwarfare";
            String dependencia = "geckoanimfix";
            String versionActual = "desconocida";
            for (int i = 1; i <= 3; ++i) {
                String lineaSiguiente;
                if (numero_de_linea + i >= this.lineasConsola.length || !(lineaSiguiente = this.lineasConsola[numero_de_linea + i].trim()).contains("Currently,") || !lineaSiguiente.contains("geckoanimfix")) continue;
                if (lineaSiguiente.contains("is \u00a7o")) {
                    versionActual = lineaSiguiente.substring(lineaSiguiente.indexOf("is \u00a7o") + 5).trim();
                    break;
                }
                if (!lineaSiguiente.contains("is ")) break;
                versionActual = lineaSiguiente.substring(lineaSiguiente.indexOf("is ") + 3).trim();
                break;
            }
            if (this.errores.add(mensaje = MonitorDePID.idioma.errorSuperbWarfareIncompatible(modId, dependencia, versionActual))) {
                String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                this.enlacesPorError.put(mensaje, enlace);
                this.activado = true;
            }
        }
        catch (Exception e) {
            consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    private List<String[]> extraerMultiplesDependencias(String linea) {
        String[] partes;
        ArrayList<String[]> dependencias = new ArrayList<String[]>();
        String parteDependencias = "";
        if (linea.contains(" requires ")) {
            parteDependencias = linea.substring(linea.indexOf(" requires ") + 10);
        } else if (linea.contains(" only supports ")) {
            parteDependencias = linea.substring(linea.indexOf(" only supports ") + 16);
        }
        if (parteDependencias.contains(" or above")) {
            parteDependencias = parteDependencias.substring(0, parteDependencias.indexOf(" or above"));
        }
        if (parteDependencias.contains(" and below")) {
            parteDependencias = parteDependencias.substring(0, parteDependencias.indexOf(" and below"));
        }
        parteDependencias = parteDependencias.replace(" and ", ", ");
        for (String parte : partes = parteDependencias.split(",")) {
            String dependenciaLimpia = parte.trim();
            if (dependenciaLimpia.contains(" ")) {
                String[] partesDep = dependenciaLimpia.split(" ", 2);
                String nombreDep = partesDep[0].trim();
                String versionDep = partesDep[1].trim();
                dependencias.add(new String[]{nombreDep, versionDep});
                continue;
            }
            dependencias.add(new String[]{dependenciaLimpia, ""});
        }
        return dependencias;
    }

    private String extraerModIdNuevoFormato(String linea) {
        int inicio = linea.indexOf("Mod ") + 4;
        int fin = linea.indexOf(" ", inicio);
        return this.limpiarFormato(linea.substring(inicio, fin));
    }

    private String extraerDependenciaNuevoFormato(String linea) {
        int inicio = linea.contains(" requires ") ? linea.indexOf(" requires ") + 10 : linea.indexOf(" only supports ") + 16;
        int fin = linea.indexOf(" ", inicio);
        if (fin == -1 || fin < inicio) {
            fin = linea.length();
        }
        return this.limpiarFormato(linea.substring(inicio, fin));
    }

    private String extraerVersionRequeridaNuevoFormato(String linea) {
        String resultado;
        int inicioVersion = linea.contains(" requires ") ? linea.indexOf(" requires ") + 10 : linea.indexOf(" only supports ") + 16;
        int finMod = linea.indexOf(" ", inicioVersion);
        if (finMod == -1) {
            return "";
        }
        int inicio = linea.indexOf(" ", finMod) + 1;
        int fin = linea.indexOf(" or above");
        if (fin == -1) {
            fin = linea.indexOf(" and below");
        }
        if (fin == -1) {
            fin = linea.length();
        }
        if ((resultado = linea.substring(inicio, fin).trim()).contains(",")) {
            resultado = resultado.substring(0, resultado.indexOf(",")).trim();
        }
        if (resultado.contains(" and ")) {
            resultado = resultado.substring(0, resultado.indexOf(" and ")).trim();
        }
        return resultado;
    }

    private String extraerVersionActualNuevoFormato(String linea) {
        int inicio = linea.indexOf("is ") + 3;
        if (inicio < 3) {
            inicio = linea.indexOf("not installed") > 0 ? linea.indexOf("not installed") : linea.length();
        }
        return inicio < linea.length() ? this.limpiarFormato(linea.substring(inicio)) : "no especificada";
    }

    private String extraerModId(String linea) {
        int inicio = linea.indexOf("Mod ") + 4;
        int fin = linea.indexOf(" only supports");
        if (fin == -1) {
            fin = linea.indexOf(" requires");
        }
        return this.limpiarFormato(linea.substring(inicio, fin));
    }

    private String extraerDependencia(String linea) {
        String clave = linea.contains("only supports") ? "supports " : "requires ";
        int inicio = linea.indexOf(clave) + clave.length();
        int fin = linea.indexOf(" ", inicio);
        return this.limpiarFormato(linea.substring(inicio, fin));
    }

    private String extraerVersionRequerida(String linea) {
        String clave = linea.contains("only supports") ? "supports " : "requires ";
        int inicio = linea.indexOf(clave) + clave.length();
        int fin = linea.indexOf(" or above");
        return this.limpiarFormato(linea.substring(inicio, fin));
    }

    private String extraerVersionActual(String linea, String dependencia) {
        int inicio = linea.indexOf("is ") + 3;
        return this.limpiarFormato(linea.substring(inicio));
    }

    private String limpiarFormato(String texto) {
        return texto.replaceAll("\u00a7[a-zA-Z0-9]", "");
    }

    private void procesarFormatoEspecial(Consola consola, String lineaActual, int numero_de_linea) {
        try {
            String mensaje;
            String lineaLimpia = this.limpiarFormato(lineaActual);
            String modId = lineaLimpia.substring(lineaLimpia.indexOf("Mod ") + 4, lineaLimpia.indexOf(" only supports")).trim();
            String dependencia = lineaLimpia.substring(lineaLimpia.indexOf("supports ") + 9, lineaLimpia.indexOf(" ", lineaLimpia.indexOf("supports ") + 9)).trim();
            String versionRequerida = lineaLimpia.substring(lineaLimpia.indexOf(dependencia) + dependencia.length(), lineaLimpia.indexOf(" or above")).trim();
            String versionActual = "no encontrada";
            for (int i = 1; i <= 3; ++i) {
                String lineaSiguiente;
                if (numero_de_linea + i >= this.lineasConsola.length || !(lineaSiguiente = this.limpiarFormato(this.lineasConsola[numero_de_linea + i].trim())).startsWith("Currently,") || !lineaSiguiente.contains(dependencia)) continue;
                versionActual = lineaSiguiente.substring(lineaSiguiente.indexOf("is ") + 3).trim();
                break;
            }
            if (this.errores.add(mensaje = MonitorDePID.idioma.errorVersionDependencia(modId, dependencia, versionRequerida, versionActual))) {
                String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                this.enlacesPorError.put(mensaje, enlace);
                this.activado = true;
            }
        }
        catch (Exception e) {
            consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new FaltasDependenciasModLaunche();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1100.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        CDStringBuilder html = new CDStringBuilder();
        html.append(MonitorDePID.idioma.no_tienes_las_dependencias_necesarias());
        Iterator<String> iterator = this.errores.iterator();
        while (iterator.hasNext()) {
            String error;
            String cleanError = error = iterator.next();
            if (html.toString().contains(cleanError)) continue;
            String enlace = this.enlacesPorError.getOrDefault(cleanError, "");
            html.append("\u2022").append(cleanError).append(" ").append(enlace);
            if (html.toString().endsWith("<br>")) continue;
            html.append("<br>");
        }
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_faltas_dependencias_de_modlauncher();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "faltas_dependencias_modlauncher";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String contenido = trazo.trace;
        for (String error : this.errores) {
            String trim;
            if (error == null || error.isEmpty() || (trim = error.trim()).isEmpty() || !contenido.contains(trim)) continue;
            return true;
        }
        if (contenido.contains("Failure message: Mod ") && (contenido.contains(" requires ") || contenido.contains(" only supports ")) && contenido.contains("Currently,")) {
            return true;
        }
        return contenido.contains("Missing or unsupported mandatory dependencies:") || contenido.contains("only supports") && contenido.contains("or above") || contenido.contains("requires") && contenido.contains("or above") && contenido.contains("Currently,");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

