/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class FuncionesDeDensidadNoVinculadas
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private final List<String> clavesFaltantes = new ArrayList<String>();
    private final List<String> modsUbicacion = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        int pos = FuncionesDeDensidadNoVinculadas.indexOfIgnoreCase(contenido, "unbound values in registry");
        if (pos < 0) {
            return;
        }
        int marker = contenido.indexOf("]: [", pos);
        if (marker < 0) {
            return;
        }
        int start = marker + 4;
        int end = contenido.indexOf(93, start);
        if (end < 0) {
            return;
        }
        String lista = contenido.substring(start, end);
        String[] partes = lista.split(",");
        this.clavesFaltantes.clear();
        HashSet<String> namespaces = new HashSet<String>();
        for (String p : partes) {
            String ns;
            int c;
            String k = p.trim();
            if (k.isEmpty() || (c = k.indexOf(58)) <= 0 || "minecraft".equals(ns = k.substring(0, c).trim())) continue;
            this.clavesFaltantes.add(k);
            namespaces.add(ns);
        }
        if (this.clavesFaltantes.isEmpty()) {
            return;
        }
        this.modsUbicacion.clear();
        Buscardor.cargar();
        for (String ns : namespaces) {
            List<ArchivoDeMod> mods = Buscardor.buscarModsConTermino("data/" + ns + "/");
            if (mods.isEmpty()) {
                mods = Buscardor.buscarModsConTermino(ns);
            }
            this.modsUbicacion.addAll(Buscardor.obtenerUbicaciones(mods));
        }
        this.mensaje = MonitorDePID.idioma.errorFuncionesDeDensidadNoVinculadas(this.clavesFaltantes);
        if (!this.modsUbicacion.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<br>").append("Posibles proveedores: <b>");
            for (int i = 0; i < this.modsUbicacion.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.modsUbicacion.get(i));
                if (i < 4 || i + 1 >= this.modsUbicacion.size()) continue;
                sb.append(", y otros");
                break;
            }
            sb.append("</b>.");
            this.mensaje = this.mensaje + sb.toString();
        }
        int linea = FuncionesDeDensidadNoVinculadas.contarSaltosDeLinea(contenido, pos);
        this.enlaceHtml = consola.agregarErrorALectador(linea, this);
        this.activado = true;
    }

    @Override
    public Verificaciones nueva() {
        return new FuncionesDeDensidadNoVinculadas();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 820.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeFuncionesDeDensidadNoVinculadas();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoFuncionesDeDensidadNoVinculadas()).construir();
    }

    private static int indexOfIgnoreCase(String haystack, String needle) {
        String h = haystack.toLowerCase(Locale.ROOT);
        String n = needle.toLowerCase(Locale.ROOT);
        return h.indexOf(n);
    }

    private static int contarSaltosDeLinea(String s, int hasta) {
        int lineas = 0;
        for (int i = 0; i < hasta && i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\n') continue;
            ++lineas;
        }
        return lineas;
    }

    @Override
    public String id() {
        return "funciones_de_densidad_no_vinculadas";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

