/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashSet;
import java.util.Set;

public class IndependenteFlywheel
implements Verificaciones {
    boolean tiene_uno = false;
    public Set<String> mods = new HashSet<String>();
    boolean activado = false;
    String enlace = "";

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar.contains("flywheel is 1")) {
            this.tiene_uno = true;
            this.mods.addAll(Buscardor.obtenerModsConNombre("flywheel"));
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int num) {
        if (this.tiene_uno && linea.contains("requires flywheel") && linea.contains("and below 0.")) {
            this.enlace = consola.agregarErrorALectador(num, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new IndependenteFlywheel();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1200.0f;
    }

    @Override
    public String mensaje() {
        String mensajeBase = MonitorDePID.idioma.mensajeIndependenteFlywheel(this.mods);
        return mensajeBase + this.enlace;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreIndependenteFlywheel();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "flywheel_independente";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

