/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class IrisShaderpackNoEncontrado
implements Verificaciones {
    private boolean posibleErrorShaderpack = false;
    private boolean activado = false;
    private String enlace = "";
    private String shaderpack = "";

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar.contains("java.nio.file.FileSystemNotFoundException") && consola.contenido_verificar.contains("shaderpacks")) {
            this.posibleErrorShaderpack = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int num) {
        if (!this.posibleErrorShaderpack) {
            return;
        }
        if (linea.contains("FileSystemNotFoundException") && linea.contains("shaderpacks")) {
            this.shaderpack = this.extraerNombreShaderpack(linea);
            this.enlace = consola.agregarErrorALectador(num, this);
            this.activado = true;
        }
    }

    private String extraerNombreShaderpack(String linea) {
        try {
            int idx = linea.lastIndexOf("shaderpacks");
            if (idx == -1) {
                return "";
            }
            String sub = linea.substring(idx);
            int slash = (sub = sub.replace("\\", "/")).lastIndexOf("/");
            if (slash != -1) {
                return sub.substring(slash + 1).trim();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Verificaciones nueva() {
        return new IrisShaderpackNoEncontrado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1250.0f;
    }

    @Override
    public String mensaje() {
        return MonitorDePID.idioma.mensajeIrisShaderpackNoEncontrado(this.shaderpack) + this.enlace;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreIrisShaderpackNoEncontrado();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "iris_shaderpack_no_encontrado";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

