/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class KubeJSResourcePack
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> errores = new HashSet<String>();
    private final Map<String, String> enlacesPorError = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!linea.contains("from pack KubeJS Resource Pack [data]") || !linea.contains("Failed to parse ")) {
            return;
        }
        try {
            String modNombre = linea.split("Failed to parse ")[1].split(":")[0];
            String mensaje = MonitorDePID.idioma.kubeJSResourcePack(modNombre);
            if (this.errores.add(mensaje)) {
                String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                this.enlacesPorError.put(mensaje, enlace);
            }
            this.activado = true;
        }
        catch (Exception e) {
            consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new KubeJSResourcePack();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 300.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (String error : this.errores) {
            String enlace = this.enlacesPorError.getOrDefault(error, "");
            html.append("<li>").append(error).append(" ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_faltar_de_kubejs_resourcepack();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "kubejs_resourcepack";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("from pack KubeJS Resource Pack [data]") && t.contains("Failed to parse ");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

