/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class LegacyRandomSourceMultiHilos
implements Verificaciones {
    boolean activado = false;

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar.contains("net.minecraft.ReportedException: Accessing LegacyRandomSource from multiple threads")) {
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new LegacyRandomSourceMultiHilos();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return MonitorDePID.idioma.mensajeLegacyRandomSourceMultiHilos();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreLegacyRandomSourceMultiHilos();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionInstalarMod("Unsafe World Random Access Detector")).construir();
    }

    @Override
    public String id() {
        return "legacy_random_source_multihilo";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

