/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LenguajeProveedorCheck
implements Verificaciones {
    private final Set<String> errores = new HashSet<String>();
    public boolean activado = false;
    private final Map<String, String> enlacesPorError = new HashMap<String, String>();
    private String[] lineasConsola = null;

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        String lineaActual;
        if (this.activado) {
            return;
        }
        if (this.lineasConsola == null) {
            this.lineasConsola = consola.contenido_verificar.split(Verificaciones.nl);
        }
        if ((lineaActual = linea).contains("Mod File") && lineaActual.contains("needs language provider")) {
            try {
                String archivoJar = lineaActual.split("Mod File ")[1].split(" needs")[0].trim();
                String proveedor = lineaActual.split("language provider ")[1].split(" ")[0].trim();
                String req = proveedor.split(":")[1];
                String encontrado = "";
                for (int j = numero_de_linea; j < this.lineasConsola.length; ++j) {
                    if (!this.lineasConsola[j].contains("We have found ")) continue;
                    encontrado = this.lineasConsola[j].split("We have found ")[1].split("\u00a7")[0].trim();
                    break;
                }
                String mensaje = MonitorDePID.idioma.errorProveedorVersion(archivoJar, proveedor.split(":")[0], req, encontrado);
                if (proveedor.toLowerCase().contains("javafml")) {
                    mensaje = mensaje + "<br>" + MonitorDePID.idioma.errorJavaFML_MCForge();
                }
                if (this.errores.add(mensaje)) {
                    String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                    this.enlacesPorError.put(mensaje, enlace);
                }
                this.activado = true;
            }
            catch (Exception e) {
                CrashDetectorLogger.logException(e);
                consola.agregarErrorALectador(numero_de_linea, this);
            }
        }
    }

    @Override
    public Verificaciones nueva() {
        return new LenguajeProveedorCheck();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (String error : this.errores) {
            String enlace = this.enlacesPorError.getOrDefault(error, "");
            html.append("<li>").append(error).append(" ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_lenguaje_proveedor_check();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "lenguaje_proveedor_check";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("Mod File") && t.contains("needs language provider");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

