/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;

public class LexForgeMLTransformerEnNeoForge
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String claseReceptora = "";
    private final String interfazObjetivo = "cpw.mods.modlauncher.api.ITransformer";
    private final String firmaMetodoFaltante = "TargetType getTargetType()";
    private final List<String> modsUbicacion = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        String l = linea;
        if (l.contains("Receiver class ") && l.contains("does not define or inherit an implementation") && l.contains("cpw.mods.modlauncher.api.TargetType getTargetType()") && l.contains("cpw.mods.modlauncher.api.ITransformer")) {
            int e;
            CrashDetectorLogger.log("LexForgeMLTransformerEnNeoForge: coincidencia -> " + l);
            int s = l.indexOf("Receiver class ");
            if (s >= 0 && (e = l.indexOf(" does not define", s += "Receiver class ".length())) > s) {
                this.claseReceptora = l.substring(s, e).trim();
            }
            if (!this.claseReceptora.isEmpty()) {
                String classPath = this.claseReceptora.replace('.', '/') + ".class";
                List<ArchivoDeMod> mods = Buscardor.buscarModsConTermino(classPath);
                for (ArchivoDeMod m : mods) {
                    this.modsUbicacion.add(m.ubicacion_para_publicar());
                }
            } else {
                CrashDetectorLogger.log("LexForgeMLTransformerEnNeoForge: no se pudo extraer clase receptora");
            }
            this.mensaje = MonitorDePID.idioma.errorLexForgeMLTransformerEnNeoForge(this.claseReceptora.isEmpty() ? "(desconocida)" : this.claseReceptora, "cpw.mods.modlauncher.api.ITransformer", "TargetType getTargetType()", this.modsUbicacion) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new LexForgeMLTransformerEnNeoForge();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_LexForgeMLTransformerEnNeoForge();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_LexForgeMLTransformerEnNeoForge(this.claseReceptora.isEmpty() ? "(desconocida)" : this.claseReceptora, "cpw.mods.modlauncher.api.ITransformer", "TargetType getTargetType()")).agregarEtiqueta(MonitorDePID.idioma.paso2_LexForgeMLTransformerEnNeoForge(this.modsUbicacion)).agregarEtiqueta(MonitorDePID.idioma.paso3_LexForgeMLTransformerEnNeoForge()).agregarEtiqueta(MonitorDePID.idioma.paso4_LexForgeMLTransformerEnNeoForge()).construir();
    }

    @Override
    public String id() {
        return "lexforge_ml_transformer_en_neoforge";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        boolean contieneBase;
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        boolean bl = contieneBase = t.contains("Receiver class ") && t.contains("does not define or inherit an implementation") && t.contains("cpw.mods.modlauncher.api.TargetType getTargetType()") && t.contains("cpw.mods.modlauncher.api.ITransformer");
        if (!contieneBase) {
            return false;
        }
        if (this.claseReceptora != null && !this.claseReceptora.isEmpty()) {
            return t.contains("Receiver class " + this.claseReceptora);
        }
        return true;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

