/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class LuckPermsNoCargado
implements Verificaciones {
    private boolean posibleErrorLuckPerms = false;
    private boolean activado = false;
    private String enlace = "";

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar.contains("net.luckperms.api.LuckPermsProvider$NotLoadedException")) {
            this.posibleErrorLuckPerms = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int num) {
        if (!this.posibleErrorLuckPerms) {
            return;
        }
        if (linea.contains("LuckPermsProvider$NotLoadedException")) {
            this.enlace = consola.agregarErrorALectador(num, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new LuckPermsNoCargado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1200.0f;
    }

    @Override
    public String mensaje() {
        return MonitorDePID.idioma.mensajeLuckPermsNoCargado() + this.enlace;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreLuckPermsNoCargado();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "luckperms_no_cargado";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

