/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.awt.Desktop;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class MCForgeInstallacionNoEstaCompleta
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private static final Pattern PATTERN_INVALID_PATHS = Pattern.compile("java\\.io\\.UncheckedIOException: java\\.io\\.IOException: Invalid paths argument, contained no existing paths: \\[(.*?)(forge-.*?client\\.jar|fmlcore-.*?\\.jar)\\]");
    private static final Pattern PATTERN_FAILED_TO_FIND_VERSION = Pattern.compile("Failed to find Minecraft resource version (.*?) at (.*?forge-.*?-client\\.jar)");
    private static final Pattern PATTERN_CANNOT_FIND_LAUNCH_TARGET = Pattern.compile("Cannot find launch target fmlclient, unable to launch");
    private static final Pattern PATTERN_MINECRAFT_CLASS_MISSING = Pattern.compile("java\\.lang\\.IllegalStateException: Could not find net/minecraft/client/Minecraft\\.class in classloader SecureModuleClassLoader");

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        Matcher matcherInvalidPaths = PATTERN_INVALID_PATHS.matcher(contenidoConsola);
        Matcher matcherFailedToFindVersion = PATTERN_FAILED_TO_FIND_VERSION.matcher(contenidoConsola);
        Matcher matcherCannotFindTarget = PATTERN_CANNOT_FIND_LAUNCH_TARGET.matcher(contenidoConsola);
        Matcher matcherMinecraftClassMissing = PATTERN_MINECRAFT_CLASS_MISSING.matcher(contenidoConsola);
        if (matcherInvalidPaths.find()) {
            this.mensaje = MonitorDePID.idioma.forgeArchivosFaltantes(matcherInvalidPaths.group(2));
            this.activado = true;
        } else if (matcherFailedToFindVersion.find()) {
            this.mensaje = MonitorDePID.idioma.forgeVersionNoEncontrada(matcherFailedToFindVersion.group(1), matcherFailedToFindVersion.group(2));
            this.activado = true;
        } else if (matcherCannotFindTarget.find()) {
            this.mensaje = MonitorDePID.idioma.forgeTargetFmlclientNoEncontrado();
            this.activado = true;
        } else if (matcherMinecraftClassMissing.find()) {
            this.mensaje = MonitorDePID.idioma.forgeClaseMinecraftFaltante();
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new MCForgeInstallacionNoEstaCompleta();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 750.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje + " " + MonitorDePID.idioma.forgeInstallacionNoCompleta();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_forge_instalacion_no_completa();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucion_para_forge_instalacion_no_completa()).agregarBoton(MonitorDePID.idioma.descargar_forge_oficial(), bool -> this.abrirEnNavegador("https://files.minecraftforge.net/")).agregarBoton(MonitorDePID.idioma.reinstalar_forge_correctamente(), bool -> JOptionPane.showMessageDialog(null, MonitorDePID.idioma.instrucciones_reinstalar_forge(), MonitorDePID.idioma.titulo_instrucciones_reinstaler_mcforge(), 1)).construir();
    }

    @Override
    private void abrirEnNavegador(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String id() {
        return "mcforge_installacion_no_esta_completa";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return PATTERN_INVALID_PATHS.matcher(t).find() || PATTERN_FAILED_TO_FIND_VERSION.matcher(t).find() || PATTERN_CANNOT_FIND_LAUNCH_TARGET.matcher(t).find() || PATTERN_MINECRAFT_CLASS_MISSING.matcher(t).find();
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

