/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MCForgeModsSuspechoso
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> errores = new HashSet<String>();
    private final Map<String, String> enlacesPorError = new HashMap<String, String>();
    private final Map<String, String> modidPorError = new HashMap<String, String>();
    private final Pattern patronNivelLogParaSaltar = Pattern.compile("^\\[[^\\]]*/(DEBUG|TRACE)\\].*");
    private final Pattern pModidEnLinea = Pattern.compile("(?i)for\\s+modid\\s+([a-z0-9_\\-.]+)");
    private final Pattern pModIdDosPuntos = Pattern.compile("(?i)\\bMod\\s*ID\\s*:\\s*([a-z0-9_\\-.]+)");
    private final Pattern pModidIgual = Pattern.compile("(?i)\\bmodid=([a-z0-9_\\-.]+)");
    private final Pattern patronDespachoModid = Pattern.compile("(?i)(?:encountered\\s+an\\s+(?:error|exception)|caught\\s+exception)\\s+during\\s+.*?dispatch\\s+for\\s+modid\\s+([a-z0-9_\\-.]+)");
    private final Pattern patronModSection = Pattern.compile("(?i)--\\s*MOD\\s+([a-z0-9_\\-.]+)\\s*--");
    private final Pattern patronSuspectedMod = Pattern.compile("(?i)\\b([a-z0-9_\\-.]+)\\s*\\(([a-z0-9_\\-.]+)\\)");
    private final Pattern patronIndicadorError = Pattern.compile("(?i)(error|exception|fail|crash|problem|unable|cannot|didn't|couldn't|missing|corrupt|invalid|unsupported)");

    private String extraerModidDeLinea(String linea, boolean esSeccionSuspectedMod) {
        Matcher mSuspected;
        if (linea == null || linea.isEmpty()) {
            return null;
        }
        if (esSeccionSuspectedMod && linea.contains("(") && linea.contains(")") && (mSuspected = this.patronSuspectedMod.matcher(linea)).find()) {
            return mSuspected.group(2).trim();
        }
        Matcher m = this.patronModSection.matcher(linea);
        if (m.find()) {
            return m.group(1).trim();
        }
        m = this.pModidEnLinea.matcher(linea);
        if (m.find()) {
            return m.group(1).trim();
        }
        m = this.pModIdDosPuntos.matcher(linea);
        if (m.find()) {
            return m.group(1).trim();
        }
        m = this.pModidIgual.matcher(linea);
        if (m.find()) {
            return m.group(1).trim();
        }
        return null;
    }

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        String[] lineas = contenidoConsola.split(Verificaciones.nl);
        boolean encontradoModSospechoso = false;
        boolean encontradoStacktrace = false;
        boolean encontradoModSection = false;
        for (int i = 0; i < lineas.length; ++i) {
            String modID;
            String enlace;
            String mensaje;
            String linea = lineas[i].trim();
            if (this.patronNivelLogParaSaltar.matcher(linea).matches()) continue;
            Matcher mModSection = this.patronModSection.matcher(linea);
            if (mModSection.find()) {
                encontradoModSection = true;
                String modID2 = mModSection.group(1).trim();
                if (modID2.isEmpty()) continue;
                String mensaje2 = MonitorDePID.idioma.mcforge_mod_sospechoso() + modID2;
                if (this.errores.add(mensaje2)) {
                    String enlace2 = consola.agregarErrorALectador(i, this);
                    this.enlacesPorError.put(mensaje2, enlace2);
                    this.modidPorError.put(mensaje2, modID2);
                }
                this.activado = true;
                continue;
            }
            if (linea.equalsIgnoreCase("Suspected Mod:") || linea.equalsIgnoreCase("Suspected Mods:")) {
                encontradoModSospechoso = true;
                encontradoStacktrace = false;
                continue;
            }
            if (linea.contains("Stacktrace:")) {
                encontradoModSospechoso = false;
                encontradoStacktrace = true;
                continue;
            }
            if (encontradoModSospechoso) {
                if (linea.isEmpty() || linea.startsWith("--") || linea.contains("Details:")) continue;
                Matcher mSuspected = this.patronSuspectedMod.matcher(linea);
                if (mSuspected.find()) {
                    String next;
                    String modID3 = mSuspected.group(2).trim();
                    if (!modID3.isEmpty()) {
                        mensaje = MonitorDePID.idioma.mcforge_mod_sospechoso() + modID3;
                        if (this.errores.add(mensaje)) {
                            enlace = consola.agregarErrorALectador(i, this);
                            this.enlacesPorError.put(mensaje, enlace);
                            this.modidPorError.put(mensaje, modID3);
                        }
                        this.activado = true;
                    }
                    while (i + 1 < lineas.length && ((next = lineas[i + 1].trim()).startsWith("Mixin class:") || next.startsWith("Target:") || next.startsWith("at TRANSFORMER/"))) {
                        ++i;
                    }
                    continue;
                }
                String modID4 = this.extraerModidDeLinea(linea, true);
                if (modID4 == null || modID4.isEmpty() || modID4.contains(".java")) continue;
                mensaje = MonitorDePID.idioma.mcforge_mod_sospechoso() + modID4;
                if (this.errores.add(mensaje)) {
                    enlace = consola.agregarErrorALectador(i, this);
                    this.enlacesPorError.put(mensaje, enlace);
                    this.modidPorError.put(mensaje, modID4);
                }
                this.activado = true;
                continue;
            }
            if (linea.contains("Failed to create mod instance. ModID:")) {
                char c;
                String prefijo = "Failed to create mod instance. ModID: ";
                int indiceInicio = linea.indexOf(prefijo);
                if (indiceInicio == -1) continue;
                String resto = linea.substring(indiceInicio += prefijo.length()).trim();
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < resto.length() && (Character.isLetterOrDigit(c = resto.charAt(j)) || c == '_' || c == '-' || c == '.' || c == '+'); ++j) {
                    sb.append(c);
                }
                String modID5 = sb.toString().trim();
                if (modID5.isEmpty()) continue;
                String mensaje3 = MonitorDePID.idioma.mcforge_mod_sospechoso() + modID5;
                if (this.errores.add(mensaje3)) {
                    String enlace3 = consola.agregarErrorALectador(i, this);
                    this.enlacesPorError.put(mensaje3, enlace3);
                    this.modidPorError.put(mensaje3, modID5);
                }
                this.activado = true;
                continue;
            }
            Matcher matcherDespacho = this.patronDespachoModid.matcher(linea);
            while (matcherDespacho.find()) {
                String modID6 = matcherDespacho.group(1).trim();
                mensaje = MonitorDePID.idioma.mcforge_mod_sospechoso() + modID6;
                if (this.errores.add(mensaje)) {
                    enlace = consola.agregarErrorALectador(i, this);
                    this.enlacesPorError.put(mensaje, enlace);
                    this.modidPorError.put(mensaje, modID6);
                }
                this.activado = true;
            }
            if (encontradoModSection || !this.patronIndicadorError.matcher(linea).find() || (modID = this.extraerModidDeLinea(linea, false)) == null || modID.isEmpty()) continue;
            mensaje = MonitorDePID.idioma.mcforge_mod_sospechoso() + modID;
            if (this.errores.add(mensaje)) {
                enlace = consola.agregarErrorALectador(i, this);
                this.enlacesPorError.put(mensaje, enlace);
                this.modidPorError.put(mensaje, modID);
            }
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new MCForgeModsSuspechoso();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        if (this.errores.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder("<ul>");
        for (String error : this.errores) {
            List<String> ubicaciones;
            String enlace = this.enlacesPorError.getOrDefault(error, "");
            String extraUbicaciones = "";
            String modid = this.modidPorError.get(error);
            if (modid != null && !modid.isEmpty() && !(ubicaciones = Buscardor.obtenerModsConNombre(modid)).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < ubicaciones.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(ubicaciones.get(i));
                }
                extraUbicaciones = " (" + sb + ")";
            }
            html.append("<li>").append(error).append(extraUbicaciones);
            if (!enlace.isEmpty()) {
                html.append(" ").append(enlace);
            }
            html.append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_mcforge_mod_sespechoso();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta("No hay soluci\u00f3n disponible").construir();
    }

    @Override
    public String id() {
        return "mcforge_mods_sospechoso";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

