/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.nio.file.Path;

public class MalwareFalsoCrashAssistant
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private TipoDeteccion tipo = null;

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        String patronMalware = "Crash Assistant detected malware or malware-like mod(s)";
        String patronModsIncompatibles = "Crash Assistant detected incompatible mod(s), crashing to prevent potential issues";
        String patronModpackIncompatible = "It marked as incompatible with this modpack";
        if (linea.contains(patronModsIncompatibles)) {
            this.tipo = TipoDeteccion.MODS_INCOMPATIBLES_FALSO;
            this.activado = true;
            this.mensaje = MonitorDePID.idioma.advertenciaCrashAssistantModsIncompatibles() + "<br>";
            return;
        }
        if (linea.contains(patronModpackIncompatible)) {
            this.tipo = TipoDeteccion.MODPACK_INCOMPATIBLE;
            this.activado = true;
            this.mensaje = MonitorDePID.idioma.advertenciaCrashAssistantModpackIncompatibleFalso() + "<br>";
            return;
        }
        if (linea.contains(patronMalware)) {
            this.tipo = TipoDeteccion.MALWARE_FALSO;
            this.activado = true;
            this.mensaje = MonitorDePID.idioma.advertenciaMalwareFalso() + "<br>";
        }
    }

    @Override
    public Verificaciones nueva() {
        return new MalwareFalsoCrashAssistant();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        Path imgPath = Statics.carpeta.resolve("imagenes").resolve("sabalifecruel.png");
        String imgUri = imgPath.toUri().toString();
        return this.mensaje + "<br><img src=\"" + imgUri + "\" alt=\"imagen\" />";
    }

    @Override
    public String nombre() {
        if (this.tipo == TipoDeteccion.MODS_INCOMPATIBLES_FALSO) {
            return MonitorDePID.idioma.nombre_de_mods_incompatibles_crash_assistant();
        }
        if (this.tipo == TipoDeteccion.MODPACK_INCOMPATIBLE) {
            return MonitorDePID.idioma.nombre_de_modpack_incompatible_crash_assistant();
        }
        return MonitorDePID.idioma.nombre_de_malware_falso_crash_assistant();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "malware_falso_crashassistant";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        switch (this.tipo.ordinal()) {
            case 1: {
                return t.contains("Crash Assistant detected incompatible mod(s), crashing to prevent potential issues");
            }
            case 2: {
                return t.contains("Crashing game and starting Crash Assistant") && t.contains("It marked as incompatible with this modpack");
            }
        }
        return t.contains("Crash Assistant detected malware or malware-like mod(s)");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    private static enum TipoDeteccion {
        MALWARE_FALSO,
        MODS_INCOMPATIBLES_FALSO,
        MODPACK_INCOMPATIBLE;

    }
}

