/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ModsDuplicadosModLauncher
implements Verificaciones {
    private boolean activado = false;
    private final CDStringBuilder mensaje = new CDStringBuilder();
    private boolean hayDuplicados = false;
    private boolean cabeceraA\u00f1adida = false;

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        boolean bl = this.hayDuplicados = contenidoConsola.contains("Found duplicate mods") || contenidoConsola.contains("Found more than one mod with modid");
        if (!this.hayDuplicados) {
            return;
        }
        if (!this.cabeceraA\u00f1adida) {
            this.mensaje.append(MonitorDePID.idioma.no_tienes_las_dependencias_necesarias()).append("<br>");
            this.cabeceraA\u00f1adida = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!this.hayDuplicados) {
            return;
        }
        String lineaActual = linea;
        if (lineaActual.contains("Mod ID") && lineaActual.contains("from mod files")) {
            String mensajeMod = MonitorDePID.idioma.modlauncher_mods_duplicado(lineaActual);
            String enlace = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje.append(mensajeMod).append(" ").append(enlace).append("<br>");
            this.activado = true;
        } else if (lineaActual.contains("Found more than one mod with modid \"crash_assistant\". Crash Assistant is duplicated. Crashing!")) {
            String enlace = consola.agregarErrorALectador(numero_de_linea, this);
            this.mensaje.append("crash_assistant").append(" ").append(enlace).append("<br>");
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ModsDuplicadosModLauncher();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1050.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_mods_duplicados_modlauncher();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "mods_duplicados_modlauncher";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

