/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class NightConfigNoSePuedeEscribir
implements Verificaciones {
    private boolean posibleErrorEscritura = false;
    private boolean activado = false;
    private String enlace = "";
    private String rutaConfig = "";

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar.contains("com.electronwill.nightconfig.core.io.WritingException") && consola.contenido_verificar.contains("Failed to write")) {
            this.posibleErrorEscritura = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int num) {
        if (!this.posibleErrorEscritura) {
            return;
        }
        if (linea.contains("WritingException") && linea.contains("Failed to write")) {
            this.rutaConfig = this.extraerRuta(linea);
            this.enlace = consola.agregarErrorALectador(num, this);
            this.activado = true;
        }
    }

    private String extraerRuta(String linea) {
        try {
            int idx = linea.lastIndexOf("to:");
            if (idx == -1) {
                return "";
            }
            return linea.substring(idx + 3).trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public Verificaciones nueva() {
        return new NightConfigNoSePuedeEscribir();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1100.0f;
    }

    @Override
    public String mensaje() {
        return MonitorDePID.idioma.mensajeNightConfigNoSePuedeEscribir(this.rutaConfig) + this.enlace;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreNightConfigNoSePuedeEscribir();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "nightconfig_no_se_puede_escribir";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

