/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NoPuedeAnalizarJSONDeRegistro
implements Verificaciones {
    boolean activado = false;
    private final List<String> erroresJSON = new ArrayList<String>();
    private final Map<String, String> enlacesPorError = new HashMap<String, String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (!linea.contains("Failed to parse") || !linea.contains(".json from pack")) {
            return;
        }
        CrashDetectorLogger.log("Se detect\u00f3 error de an\u00e1lisis JSON en registro");
        try {
            String archivoJar = linea.split("from pack ")[1].split("\\.jar")[0].trim() + ".jar";
            String recurso = linea.split("Failed to parse ")[1].split(" from pack")[0].trim();
            String mensaje = MonitorDePID.idioma.errorConJSONDeRegistro(archivoJar, recurso);
            if (!this.erroresJSON.contains(mensaje)) {
                this.erroresJSON.add(mensaje);
                String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                this.enlacesPorError.put(mensaje, enlace);
            }
            this.activado = true;
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
            consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new NoPuedeAnalizarJSONDeRegistro();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 500.0f;
    }

    @Override
    public String mensaje() {
        if (this.erroresJSON.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder(MonitorDePID.idioma.noPuedeAnalizarJSON() + "<ul>");
        for (String error : this.erroresJSON) {
            String enlace = this.enlacesPorError.getOrDefault(error, "");
            html.append("<li>").append(error).append(" ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_no_puede_analizar_json_de_registro();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "no_puede_analizar_json_de_registro";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        return t.contains("Failed to parse") && t.contains(".json from pack");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

