/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.EliminadorDeMod;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class NoSuchElementAnimacionMinecraft
implements Verificaciones {
    private boolean activado = false;
    private String namespaceEncontrado = null;
    private String enlaceHtml = "";
    private static final Pattern PATTERN = Pattern.compile("java\\.util\\.NoSuchElementException: No animation with registry name ([a-zA-Z0-9_]+):");

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado) {
            return;
        }
        Matcher matcher = PATTERN.matcher(linea);
        if (matcher.find()) {
            this.namespaceEncontrado = matcher.group(1);
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new NoSuchElementAnimacionMinecraft();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado()) {
            return "";
        }
        Buscardor.cargar();
        String terminoBusqueda = "assets/" + this.namespaceEncontrado + "/";
        List<String> ubicaciones = Buscardor.obtenerUbicaciones(Buscardor.buscarModsConTermino(terminoBusqueda));
        StringBuilder html = new StringBuilder();
        html.append("<span style='color: #").append(Config.obtenerInstancia().obtenerColorDeTitulosDeConsolas()).append("; font-weight: bold;'>").append(MonitorDePID.idioma.error_animacion_no_encontrada()).append("</span>").append("<br>").append("<ul>");
        html.append("<li>").append(": <strong>").append(this.namespaceEncontrado).append("</strong> (").append(String.join((CharSequence)",", ubicaciones)).append(") ").append(this.enlaceHtml).append("</li>");
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_animacion_minecraft();
    }

    @Override
    public QuickFix solucion() {
        if (!this.activado()) {
            return null;
        }
        Buscardor.cargar();
        String terminoBusqueda = "assets/" + this.namespaceEncontrado + "/";
        List<String> ubicaciones = Buscardor.obtenerUbicaciones(Buscardor.buscarModsConTermino(terminoBusqueda));
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        if (ubicaciones.isEmpty()) {
            builder.agregarEtiqueta(MonitorDePID.idioma.no_se_encontraron_mods_para_eliminar());
        } else {
            for (String ubicacion : ubicaciones) {
                String botonTexto = MonitorDePID.idioma.eliminar() + ": " + ubicacion;
                builder.agregarBoton(botonTexto, retener -> {
                    block3: {
                        try {
                            EliminadorDeMod.eliminarMod(ubicacion);
                            if (!EliminadorDeMod.esModoHeadless()) {
                                JOptionPane.showMessageDialog(null, MonitorDePID.idioma.jar_eliminado_exitosamente() + ": " + ubicacion, MonitorDePID.idioma.exito(), 1);
                            }
                        }
                        catch (Exception e) {
                            CrashDetectorLogger.logException(e);
                            if (EliminadorDeMod.esModoHeadless()) break block3;
                            JOptionPane.showMessageDialog(null, MonitorDePID.idioma.error_al_eliminar_jar() + ": " + ubicacion, MonitorDePID.idioma.error(), 0);
                        }
                    }
                });
            }
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "no_such_element_animacion_minecraft";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

