/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.config.ConfigBoolean;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.json.Json;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public class PirataMC
implements Verificaciones {
    public static ConfigBoolean config = ConfigBoolean.de("condenar_pirateria", false);
    public static Path archivo_derechos_piratas = Statics.carpeta.resolve("derechos_piratas.json");
    boolean activado = false;
    String mensaje = "";

    @Override
    public void verificar(Consola consola) {
        if (config.obtener().booleanValue() && consola.contenido_verificar.contains("Caused by: com.mojang.authlib.exceptions.MinecraftClientHttpException: Status: 401")) {
            this.activado = true;
            StringBuilder mensaj = new StringBuilder(MonitorDePID.idioma.mensagjePirataMC());
            String derechos = PirataMC.obtenerDerechosMiranda();
            if (derechos != null) {
                mensaj.append("<br>").append(MonitorDePID.idioma.infoDeDerechosMiranda()).append("<br>").append(derechos);
            }
            this.mensaje = mensaj.toString();
        }
    }

    public static String obtenerDerechosMiranda() {
        if (!archivo_derechos_piratas.toFile().exists()) {
            return null;
        }
        try {
            String[] ordenDeBusqueda;
            String contenido = new String(Files.readAllBytes(archivo_derechos_piratas), StandardCharsets.UTF_8);
            if (contenido == null || contenido.trim().isEmpty()) {
                return null;
            }
            Json.Nodo raiz = Json.leer(contenido);
            if (!raiz.esObjeto()) {
                return null;
            }
            String idioma_actual = MonitorDePID.idioma.codigo();
            String idioma_respaldo = Idioma.idioma_respaldo.obtener();
            String codigo_espanol = "es";
            for (String lang : ordenDeBusqueda = new String[]{idioma_actual, idioma_respaldo, codigo_espanol}) {
                String valor;
                Json.Nodo nodo;
                if (lang == null || lang.isEmpty() || (nodo = raiz.obtener(lang)) == null || nodo.esObjeto() || nodo.esArreglo() || (valor = nodo.comoCadena()) == null || valor.trim().isEmpty()) continue;
                return valor;
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new PirataMC();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1500.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombrePirataMC();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(MonitorDePID.idioma.nombrePirataMC()).agregarBoton(MonitorDePID.idioma.desactivarVerificacionPirata(), retener -> config.escribir(true), true).agregarBoton(MonitorDePID.idioma.comprarMC(), retener -> this.abrirEnNavegador("https://www.minecraft.net/es-mx/store/minecraft-java-bedrock-edition-pc?tabs=%7B%22details%22%3A0%7D"), true).construir();
    }

    @Override
    private void abrirEnNavegador(String url) {
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            }
        }
        catch (Exception e) {
            CrashDetectorLogger.logException(e);
        }
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return trazo.trace.contains("Caused by: com.mojang.authlib.exceptions.MinecraftClientHttpException: Status: 401");
    }

    @Override
    public String id() {
        return "pirata_minecraft";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

