/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Pattern;

public class ProblemaCargaChunk
implements Verificaciones {
    private boolean activado = false;
    private String enlace = "";
    private static final Pattern PATRON_LOAD_CHUNK = Pattern.compile("at.*ChunkRegionLoader\\.loadChunk", 2);
    private static final Pattern PATRON_LOAD_ENTITIES = Pattern.compile("at.*ChunkRegionLoader\\.loadEntities", 2);
    private static final Pattern PATRON_GEN_CHUNK = Pattern.compile("Exception generating new chunk", 2);
    private static final Pattern PATRON_CANT_LOAD_CHUNK = Pattern.compile("Couldn't load chunk", 2);
    private static final Pattern PATRON_UNEXPECTED_EXCEPTION = Pattern.compile("Encountered an unexpected exception", 2);
    private boolean viUnexpectedException = false;

    @Override
    public void verificar(Consola consola) {
        this.activado = false;
        this.enlace = "";
        this.viUnexpectedException = false;
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea == null) {
            return;
        }
        String l = linea.trim();
        if (!(l.contains("exception") || l.contains("chunk") || l.contains("load") || l.contains("generate"))) {
            this.viUnexpectedException = false;
            return;
        }
        if (PATRON_UNEXPECTED_EXCEPTION.matcher(l).find()) {
            this.viUnexpectedException = true;
            return;
        }
        if (this.viUnexpectedException && (PATRON_LOAD_CHUNK.matcher(l).find() || PATRON_LOAD_ENTITIES.matcher(l).find())) {
            this.activar(consola, numero_de_linea);
            return;
        }
        if (PATRON_GEN_CHUNK.matcher(l).find() || PATRON_CANT_LOAD_CHUNK.matcher(l).find()) {
            this.activar(consola, numero_de_linea);
        }
    }

    private void activar(Consola consola, int linea) {
        if (!this.activado) {
            this.activado = true;
            this.enlace = consola.agregarErrorALectador(linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaCargaChunk();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return MonitorDePID.idioma.mensajeCargaChunk() + (this.enlace.isEmpty() ? "" : " " + this.enlace);
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaCargaChunk();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucionRepararMundo("world"));
        builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarCarpetaMundo("world"));
        builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarChunk());
        return builder.construir();
    }

    @Override
    public String id() {
        return "carga_chunk";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

