/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaCargaMultiverso
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreMundo = "";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("The world '([^']+)' could NOT be loaded because it contains errors and is probably corrupt!");
        Matcher coincidencia = patron.matcher(contenido);
        if (coincidencia.find()) {
            this.nombreMundo = coincidencia.group(1);
            this.mensaje = MonitorDePID.idioma.mensajeProblemaCargaMultiverso(this.nombreMundo) + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaCargaMultiverso();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaCargaMultiverso();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionRepararMundo(this.nombreMundo)).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarCarpetaMundo(this.nombreMundo)).construir();
    }

    @Override
    public boolean anularNormal() {
        return true;
    }

    @Override
    public String id() {
        return "carga_multiverso";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

