/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ProblemaCierreAuthMe
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";

    @Override
    public void verificar(Consola consola) {
        String contenidoDeConsola = consola.contenido_verificar;
        String mensajeAuthMe = "[AuthMe] THE SERVER IS GOING TO SHUT DOWN AS DEFINED IN THE CONFIGURATION!";
        if (contenidoDeConsola.contains(mensajeAuthMe)) {
            this.mensaje = MonitorDePID.idioma.mensajeCierreAuthMe() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaCierreAuthMe();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaCierreAuthMe();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionCierreAuthMe()).agregarEtiqueta(MonitorDePID.idioma.solucionConfigurarPluginAuthMe()).agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionDiferenteAuthMe()).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPluginAuthMe()).construir();
    }

    @Override
    public boolean anularNormal() {
        return true;
    }

    @Override
    public String id() {
        return "cierre_authme";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

