/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaDependenciaModFabric
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private static final Pattern P_INSTALAR = Pattern.compile("^-\\s*Install\\s+([^,]+),\\s*version\\s+([^\\.]+)\\s+or\\s+later\\.", 2);
    private static final Pattern P_REEMPLAZO_RANGO = Pattern.compile("^-\\s*Replace\\s+.*?\\(([^\\)]+)\\).*?with\\s+any\\s+version\\s+between\\s+([^\\s]+)\\s*\\(inclusive\\)\\s*and\\s*([^\\s]+)\\s*\\(exclusive\\)\\.", 2);
    private static final Pattern P_FALTANTE_MINIMO = Pattern.compile("^-\\s*mod\\s+.+?\\(([^\\)]+)\\)\\s*[^\\)]*\\)?\\s*.*?requires\\s+version\\s+([^\\s]+)\\s*.*?or\\s+later\\s+of\\s+([a-z0-9_\\-]+)\\s*,\\s*which\\s+is\\s+missing", 2);
    private static final Pattern P_RANGO_PRESENTE_INCORRECTO = Pattern.compile("^-\\s*mod\\s+.+?\\(([^\\)]+)\\).*?requires\\s+any\\s+version\\s+between\\s+([^\\s]+)\\s*\\(inclusive\\)\\s*and\\s*([^\\s]+)\\s*\\(exclusive\\)\\s+of\\s+mod\\s+.+?\\(([^\\)]+)\\).*?wrong\\s+version\\s+is\\s+present:\\s*([^!\\s]+)!", 2);
    private final Set<String> problemas = new LinkedHashSet<String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        String lineaLimpia = ProblemaDependenciaModFabric.limpiarLinea(linea);
        Matcher mInst = P_INSTALAR.matcher(lineaLimpia);
        if (mInst.find()) {
            String nombreDependencia = mInst.group(1).trim();
            String versionMinima = ProblemaDependenciaModFabric.normalizarVersion(mInst.group(2));
            String problema = "Instalar " + nombreDependencia + " m\u00ednima " + versionMinima;
            if (this.problemas.add(problema)) {
                consola.agregarErrorALectador(numero_de_linea, this);
            }
            return;
        }
        Matcher mReemp = P_REEMPLAZO_RANGO.matcher(lineaLimpia);
        if (mReemp.find()) {
            String idDependencia = mReemp.group(1).toLowerCase();
            String versionMinima = ProblemaDependenciaModFabric.normalizarVersion(mReemp.group(2));
            String versionMaxima = ProblemaDependenciaModFabric.normalizarVersion(mReemp.group(3));
            String problema = "Reemplazar " + idDependencia + " rango: " + versionMinima + ":" + versionMaxima;
            if (this.problemas.add(problema)) {
                consola.agregarErrorALectador(numero_de_linea, this);
            }
            return;
        }
        Matcher mFalta = P_FALTANTE_MINIMO.matcher(lineaLimpia);
        if (mFalta.find()) {
            String idMod = mFalta.group(1);
            String versionMinima = ProblemaDependenciaModFabric.normalizarVersion(mFalta.group(2));
            String idDependencia = mFalta.group(3).toLowerCase();
            String problema = idMod + " requiere " + idDependencia + " m\u00ednima " + versionMinima;
            if (this.problemas.add(problema)) {
                consola.agregarErrorALectador(numero_de_linea, this);
            }
            return;
        }
        Matcher mRango = P_RANGO_PRESENTE_INCORRECTO.matcher(lineaLimpia);
        if (mRango.find()) {
            String modSolicitante = mRango.group(1);
            String versionMinima = ProblemaDependenciaModFabric.normalizarVersion(mRango.group(2));
            String versionMaxima = ProblemaDependenciaModFabric.normalizarVersion(mRango.group(3));
            String idDependencia = mRango.group(4).toLowerCase();
            String versionActual = ProblemaDependenciaModFabric.normalizarVersion(mRango.group(5));
            String problema = modSolicitante + " rango: " + versionMinima + ":" + versionMaxima + ":" + versionActual;
            if (this.problemas.add(problema)) {
                consola.agregarErrorALectador(numero_de_linea, this);
            }
            return;
        }
    }

    private static String limpiarLinea(String s) {
        if (s == null) {
            return "";
        }
        String out = s.replaceAll("[\\u00A7][0-9A-FK-ORa-fk-or]", "").replaceAll("\\uFFFD.", "").replace('\u2219', '.').replace('\u2019', '\'').replace('\u2018', '\'').replace('\u201c', '\"').replace('\u201d', '\"').replaceAll("\\s{2,}", " ").trim();
        return out;
    }

    private static String normalizarVersion(String v) {
        if (v == null) {
            return "";
        }
        return ProblemaDependenciaModFabric.limpiarLinea(v).trim();
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaDependenciaModFabric();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1100.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaDependenciaMod();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (String problema : this.problemas) {
            builder.agregarEtiqueta(problema);
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "dependencia_mod_fabric";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

