/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaDependenciaPTRLib
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final String nombreMod = "PTRLib";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("Encountered an unexpected exception\\s*java\\.lang\\.NoClassDefFoundError: com/mia/craftstudio/IPackReaderCallback", 32);
        Matcher coincidencia = patron.matcher(contenido);
        if (coincidencia.find()) {
            this.mensaje = MonitorDePID.idioma.mensajeDependenciaModFaltante("PTRLib");
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaDependenciaPTRLib();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaDependenciaModFaltante();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionInstalarMod("PTRLib")).construir();
    }

    @Override
    public String id() {
        return "problema_dependencia_ptrlib";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

