/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProblemaDependenciaPlugin
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final Map<String, List<String>> plugins = new HashMap<String, List<String>>();
    private final Map<String, String> enlacesPorPlugin = new HashMap<String, String>();
    private String nombrePluginActual = "";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea.contains("Could not load 'plugins/")) {
            this.extraerNombrePluginDesdeRuta(linea, numero_de_linea, consola);
        } else if (linea.contains("Unknown/missing dependency plugins:")) {
            this.procesarLineaDependenciaMultiple(linea);
            this.reconstruirMensaje();
        } else if (linea.contains("Unknown dependency")) {
            this.procesarLineaDependenciaUnica(linea);
            this.reconstruirMensaje();
        }
    }

    private void extraerNombrePluginDesdeRuta(String linea, int numeroLinea, Consola consola) {
        int primerApostrofe = linea.indexOf(39);
        int segundoApostrofe = linea.indexOf(39, primerApostrofe + 1);
        if (primerApostrofe >= 0 && segundoApostrofe > primerApostrofe) {
            String ruta = linea.substring(primerApostrofe + 1, segundoApostrofe);
            this.nombrePluginActual = this.extraerNombrePlugin(ruta);
            if (!this.nombrePluginActual.isEmpty()) {
                String enlace = consola.agregarErrorALectador(numeroLinea, this);
                this.enlacesPorPlugin.put(this.nombrePluginActual, enlace);
            }
        }
    }

    private void procesarLineaDependenciaMultiple(String linea) {
        if (this.nombrePluginActual.isEmpty()) {
            return;
        }
        int inicio = linea.indexOf(91) + 1;
        int fin = linea.indexOf(93);
        if (inicio > 0 && fin > inicio) {
            String depsTexto = linea.substring(inicio, fin);
            String[] deps = depsTexto.split(", ");
            this.plugins.computeIfAbsent(this.nombrePluginActual, k -> new ArrayList());
            for (String dep : deps) {
                this.plugins.get(this.nombrePluginActual).add(dep.trim());
            }
            this.nombrePluginActual = "";
        }
    }

    private void procesarLineaDependenciaUnica(String linea) {
        if (this.nombrePluginActual.isEmpty()) {
            return;
        }
        int inicioDep = linea.indexOf("Unknown dependency ") + "Unknown dependency ".length();
        int finDep = linea.indexOf(".", inicioDep);
        if (inicioDep > 0 && finDep > inicioDep) {
            String dependencia = linea.substring(inicioDep, finDep).trim();
            this.plugins.computeIfAbsent(this.nombrePluginActual, k -> new ArrayList());
            this.plugins.get(this.nombrePluginActual).add(dependencia);
            this.nombrePluginActual = "";
        }
    }

    private void reconstruirMensaje() {
        if (this.plugins.isEmpty()) {
            this.mensaje = "";
            this.activado = false;
            return;
        }
        StringBuilder mensajeBuilder = new StringBuilder();
        boolean primerPlugin = true;
        for (Map.Entry<String, List<String>> entry : this.plugins.entrySet()) {
            String nombrePlugin = entry.getKey();
            List<String> dependencias = entry.getValue();
            String enlace = this.enlacesPorPlugin.getOrDefault(nombrePlugin, "");
            if (!primerPlugin) {
                mensajeBuilder.append("<br>");
            }
            if (dependencias.size() == 1) {
                mensajeBuilder.append(MonitorDePID.idioma.mensajeDependenciaPluginUnica(nombrePlugin, dependencias.get(0)));
            } else {
                mensajeBuilder.append(MonitorDePID.idioma.mensajeDependenciaPluginMultiples(nombrePlugin, dependencias));
            }
            mensajeBuilder.append(" ").append(enlace);
            primerPlugin = false;
        }
        this.mensaje = mensajeBuilder.toString();
        this.activado = true;
    }

    private String extraerNombrePlugin(String path) {
        int indiceUltimaBarra = path.lastIndexOf("/");
        return indiceUltimaBarra != -1 ? path.substring(indiceUltimaBarra + 1) : path;
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaDependenciaPlugin();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaDependenciaPlugin();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (Map.Entry<String, List<String>> entry : this.plugins.entrySet()) {
            String nombrePlugin = entry.getKey();
            List<String> dependencias = entry.getValue();
            if (!nombrePlugin.isEmpty()) {
                builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(nombrePlugin));
            }
            for (String dependencia : dependencias) {
                builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarPlugin(dependencia));
            }
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "dependencia_plugin";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

