/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaDependenciaPluginPocketMine
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresPlugins = new ArrayList<String>();
    private final List<String> dependencias = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("Could not load plugin '(.*?)': Unknown dependency: (.*?)\\.");
        Matcher coincidencia = patron.matcher(contenido);
        while (coincidencia.find()) {
            String nombrePlugin = coincidencia.group(1).trim();
            String dependencia = coincidencia.group(2).trim();
            if (nombrePlugin.isEmpty() || dependencia.isEmpty()) continue;
            this.nombresPlugins.add(nombrePlugin);
            this.dependencias.add(dependencia);
        }
        if (!this.nombresPlugins.isEmpty()) {
            this.mensaje = this.nombresPlugins.size() > 1 ? MonitorDePID.idioma.mensajeDependenciaPluginFaltantePlural(this.nombresPlugins, this.dependencias) : MonitorDePID.idioma.mensajeDependenciaPluginFaltanteSingular(this.nombresPlugins.get(0), this.dependencias.get(0));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaDependenciaPluginPocketMine();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaDependenciaPluginFaltante();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.nombresPlugins.size(); ++i) {
            String nombre = this.nombresPlugins.get(i);
            String dependencia = this.dependencias.get(i);
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarPlugin(dependencia));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(nombre));
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "problema_dependencia_plugin_pocketmine";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

