/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaEjecucionPlugin
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresPlugins = new ArrayList<String>();
    private final List<String> rutasPlugins = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("Error: \".*?\" \\$EXCEPTION\\$ in \"(plugins/[^\\.]+\\.phar)(?:/[^/\\\"]+)*\" at line \\d+", 32);
        Matcher coincidencia = patron.matcher(contenido);
        while (coincidencia.find()) {
            String rutaPlugin = coincidencia.group(1);
            String nombrePlugin = coincidencia.group(2);
            if (nombrePlugin.isEmpty() || this.nombresPlugins.contains(nombrePlugin)) continue;
            this.nombresPlugins.add(nombrePlugin);
            this.rutasPlugins.add(rutaPlugin);
        }
        if (!this.nombresPlugins.isEmpty()) {
            this.mensaje = this.nombresPlugins.size() > 1 ? MonitorDePID.idioma.mensajePluginEjecucionPlural(this.nombresPlugins) : MonitorDePID.idioma.mensajePluginEjecucionSingular(this.nombresPlugins.get(0));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaEjecucionPlugin();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 700.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaPluginEjecucion();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.nombresPlugins.size(); ++i) {
            String nombre = this.nombresPlugins.get(i);
            String ruta = this.rutasPlugins.get(i);
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(ruta));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionDiferentePlugin(nombre));
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "ejecucion_plugin";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

