/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaExcepcionComandoPlugin
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombrePlugin = "";
    private String comando = "";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("org\\.bukkit\\.command\\.CommandException: Cannot execute command '([^']+)' in plugin (\\w+)");
        Matcher coincidencia = patron.matcher(contenido);
        if (coincidencia.find()) {
            this.nombrePlugin = coincidencia.group(2);
            this.comando = coincidencia.group(1);
            this.mensaje = MonitorDePID.idioma.mensajeExcepcionComandoPlugin(this.nombrePlugin, this.comando) + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaExcepcionComandoPlugin();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 500.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaExcepcionComandoPlugin();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionDiferentePlugin(this.nombrePlugin)).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(this.nombrePlugin)).construir();
    }

    @Override
    public String id() {
        return "excepcion_comando_plugin";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

