/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Pattern;

public class ProblemaMCEFInicializacion
implements Verificaciones {
    private boolean activado = false;
    private String enlace = "";
    private String[] lineasTotales = null;
    private static final Pattern PATRON_MCEF = Pattern.compile("(?i)Initializing CEF on |\\[org\\.cef\\.CefApp:initialize:");

    @Override
    public void verificar(Consola consola) {
        this.lineasTotales = consola.contenido_verificar.split(Verificaciones.nl);
        this.activado = false;
        this.enlace = "";
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea == null || this.lineasTotales == null) {
            return;
        }
        if (numero_de_linea < Math.max(0, this.lineasTotales.length - 5)) {
            return;
        }
        if (PATRON_MCEF.matcher(linea).find()) {
            this.activado = true;
            this.enlace = consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaMCEFInicializacion();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 750.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        String html = MonitorDePID.idioma.problema_mcef_inicializacion_html();
        if (this.enlace.isEmpty()) {
            return html;
        }
        return html + " " + this.enlace;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_problema_mcef_inicializacion();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_eliminar_mod_mcef());
        builder.agregarEtiqueta(MonitorDePID.idioma.solucion_verificar_compatibilidad_mcef());
        return builder.construir();
    }

    @Override
    public String id() {
        return "problema_mcef_inicializacion";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

