/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaModDuplicadoFabric
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreMod = "";
    private String rutaMod = "";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("A critical error occurred\\s*net\\.fabricmc\\.loader\\.discovery\\.ModResolutionException: Duplicate versions for mod ID '([^']+)'(?:.*?at ([^\\]]+))?", 32);
        Matcher coincidencia = patron.matcher(contenido);
        if (coincidencia.find()) {
            this.nombreMod = coincidencia.group(1);
            this.rutaMod = coincidencia.group(2);
            this.mensaje = MonitorDePID.idioma.mensajeModDuplicadoFabric(this.nombreMod) + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaModDuplicadoFabric();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 850.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaModDuplicadoFabric();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarModDuplicado(this.rutaMod)).construir();
    }

    @Override
    public String id() {
        return "mod_duplicado_fabric";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

