/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaModFaltanteEnMundo
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresMods = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("This world was saved with mod (?!forge)(?!minecraft)(\\w+) which appears to be missing", 2);
        Matcher coincidencia = patron.matcher(contenido);
        while (coincidencia.find()) {
            String nombreMod = coincidencia.group(1).trim();
            if (nombreMod.isEmpty() || this.nombresMods.contains(nombreMod)) continue;
            this.nombresMods.add(nombreMod);
        }
        if (!this.nombresMods.isEmpty()) {
            this.mensaje = this.nombresMods.size() > 1 ? MonitorDePID.idioma.mensajeWorldModFaltantePlural(this.nombresMods) : MonitorDePID.idioma.mensajeWorldModFaltanteSingular(this.nombresMods.get(0));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaModFaltanteEnMundo();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 850.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaWorldModFaltante();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (String mod : this.nombresMods) {
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarMod(mod));
        }
        return builder.construir();
    }

    @Override
    public boolean anularNormal() {
        return true;
    }

    @Override
    public String id() {
        return "mod_faltante_en_mundo";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

