/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaModIncompatibleConMinecraft
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresMods = new ArrayList<String>();
    private final List<String> versionesMinecraft = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("The mod (\\S+) does not wish to run in Minecraft version Minecraft ([0-9\\.]+)\\. You will have to remove it to play\\.", 32);
        Matcher coincidencia = patron.matcher(contenido);
        while (coincidencia.find()) {
            String nombreMod = coincidencia.group(1).trim();
            String versionMC = coincidencia.group(2).trim();
            if (nombreMod.isEmpty() || versionMC.isEmpty()) continue;
            this.nombresMods.add(nombreMod);
            this.versionesMinecraft.add(versionMC);
        }
        if (!this.nombresMods.isEmpty()) {
            this.mensaje = this.nombresMods.size() > 1 ? MonitorDePID.idioma.mensajeModIncompatibleConMinecraftPlural(this.nombresMods, this.versionesMinecraft) : MonitorDePID.idioma.mensajeModIncompatibleConMinecraftSingular(this.nombresMods.get(0), this.versionesMinecraft.get(0));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaModIncompatibleConMinecraft();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaModIncompatibleConMinecraft();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.nombresMods.size(); ++i) {
            String nombreMod = this.nombresMods.get(i);
            String versionMC = this.versionesMinecraft.get(i);
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarMod(nombreMod));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionForge(versionMC));
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "mod_incompaible_con_minecraft_version";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

