/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaModIncompatibleFabric
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String primerMod = "";
    private String segundoMod = "";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("\\s*- Mod ([\\w\\-\\._]+) [^\\n]+ (?:is incompatible|conflicts) with [^\\n]+ of (?:mod )?([\\w\\-\\._]+)", 32);
        Matcher coincidencia = patron.matcher(contenido);
        if (coincidencia.find()) {
            this.primerMod = coincidencia.group(1);
            this.segundoMod = coincidencia.group(2);
            this.mensaje = MonitorDePID.idioma.mensajeModIncompatible(this.primerMod, this.segundoMod) + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaModIncompatibleFabric();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaModIncompatibleFabric();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarMod(this.primerMod)).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarMod(this.segundoMod)).construir();
    }

    @Override
    public String id() {
        return "mod_incompatible_fabric";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

