/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaNombrePluginAmbiguo
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private List<String> nombresPlugins = new ArrayList<String>();
    private List<String> primerosArchivos = new ArrayList<String>();
    private List<String> segundosArchivos = new ArrayList<String>();
    private final List<String> enlaces = new ArrayList<String>();
    private static final Pattern PATRON = Pattern.compile("Ambiguous plugin name [`']([^`']*)[`'].*?files [`']plugins/([^`']*)[`'].*?and [`']plugins/([^`']*)[`']");

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea == null) {
            return;
        }
        Matcher coincidencia = PATRON.matcher(linea.trim());
        if (coincidencia.find()) {
            this.nombresPlugins.add(coincidencia.group(1));
            this.primerosArchivos.add(this.extraerNombrePlugin(coincidencia.group(2)));
            this.segundosArchivos.add(this.extraerNombrePlugin(coincidencia.group(3)));
            String enlace = consola.agregarErrorALectador(numero_de_linea, this);
            this.enlaces.add(enlace);
            this.reconstruirMensaje();
            this.activado = true;
        }
    }

    private void reconstruirMensaje() {
        if (this.nombresPlugins.isEmpty()) {
            this.mensaje = "";
            return;
        }
        StringBuilder mensajeBuilder = new StringBuilder();
        for (int i = 0; i < this.nombresPlugins.size(); ++i) {
            String enlace = i < this.enlaces.size() ? this.enlaces.get(i) : "";
            mensajeBuilder.append(MonitorDePID.idioma.mensajeNombrePluginAmbiguo(this.nombresPlugins.get(i), this.primerosArchivos.get(i), this.segundosArchivos.get(i))).append(" ").append(enlace).append("<br>");
        }
        this.mensaje = mensajeBuilder.toString();
    }

    private String extraerNombrePlugin(String path) {
        int indiceUltimaBarra = path.lastIndexOf("/");
        return indiceUltimaBarra != -1 ? path.substring(indiceUltimaBarra + 1) : path;
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaNombrePluginAmbiguo();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 700.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaNombrePluginAmbiguo();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.primerosArchivos.size(); ++i) {
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(this.primerosArchivos.get(i)));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(this.segundosArchivos.get(i)));
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "nombre_plugin_ambiguo";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

