/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaPluginIncompatible
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresPlugins = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        Pattern[] patrones;
        String contenido = consola.contenido_verificar;
        for (Pattern patron : patrones = new Pattern[]{Pattern.compile("Could not load plugin '([^']+)'\\: Incompatible API version"), Pattern.compile("Could not load plugin '([^']+)'\\: Incompatible network protocol version")}) {
            Matcher coincidencia = patron.matcher(contenido);
            while (coincidencia.find()) {
                String nombrePlugin = coincidencia.group(1).trim();
                if (nombrePlugin.isEmpty() || this.nombresPlugins.contains(nombrePlugin)) continue;
                this.nombresPlugins.add(nombrePlugin);
            }
        }
        if (!this.nombresPlugins.isEmpty()) {
            this.mensaje = this.nombresPlugins.size() > 1 ? MonitorDePID.idioma.mensajePluginIncompatiblePlural(this.nombresPlugins) : MonitorDePID.idioma.mensajePluginIncompatibleSingular(this.nombresPlugins.get(0));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaPluginIncompatible();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaPluginIncompatible();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (String plugin : this.nombresPlugins) {
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionDiferentePlugin(plugin));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(plugin));
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "plugin_incompatible";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

