/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ProblemaSpongeMixinFabric
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreMod = "";
    private boolean viErrorMixin = false;

    @Override
    public void verificar(Consola consola) {
        this.activado = false;
        this.mensaje = "";
        this.nombreMod = "";
        this.viErrorMixin = false;
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        int indice;
        if (this.activado) {
            return;
        }
        if (linea == null) {
            return;
        }
        if (linea.contains("MixinTransformerError: An unexpected critical error was encountered")) {
            this.viErrorMixin = true;
            return;
        }
        if (this.viErrorMixin && linea.contains("from mod ") && (indice = linea.indexOf("from mod ")) != -1) {
            String candidato = linea.substring(indice + "from mod ".length()).trim();
            int fin = candidato.indexOf(32);
            if (fin == -1) {
                fin = candidato.length();
            }
            this.nombreMod = candidato.substring(0, fin);
            this.activado = true;
            this.mensaje = MonitorDePID.idioma.mensajeModFatal(this.nombreMod) + "<br>";
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaSpongeMixinFabric();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaModFatal();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarMod(this.nombreMod)).construir();
    }

    @Override
    public String id() {
        return "problema_spongemixin_fabric";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

