/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class ProblemaTickingEntidadBloque
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String nombreEntidad = "";
    private String tipoEntidad = "";
    private int[] coordenadas = new int[3];
    private boolean coordenadasValidas = false;
    private String enlaceHtml = "";
    private boolean hayTickingBlockEntityEnLog = false;
    private boolean bloqueActivo = false;
    private int lineaInicioBloque = -1;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        this.hayTickingBlockEntityEnLog = contenido.contains("Description: Ticking block entity");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        String[] partes;
        int indiceMod;
        if (!this.hayTickingBlockEntityEnLog || linea == null) {
            return;
        }
        String l = linea.trim();
        if (l.equals("Description: Ticking block entity")) {
            this.bloqueActivo = true;
            this.lineaInicioBloque = numero_de_linea;
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            return;
        }
        if (!this.bloqueActivo) {
            return;
        }
        int delta = numero_de_linea - this.lineaInicioBloque;
        if (delta <= 0 || delta > 20) {
            this.bloqueActivo = false;
            return;
        }
        if (l.startsWith("Name: ")) {
            this.nombreEntidad = l.substring("Name: ".length()).trim();
            this.actualizarMensajeSiCorresponde();
        }
        if ((l.startsWith("Block: ") || l.contains("Block entity being ticked")) && (indiceMod = l.indexOf(":")) > 0 && l.contains(":") && (partes = l.split(":")).length >= 2) {
            this.tipoEntidad = partes[0].trim() + ":" + partes[1].trim();
            this.actualizarMensajeSiCorresponde();
        }
        if (l.startsWith("Block location: World: (")) {
            String coordsTexto;
            String[] coords;
            int inicio = l.indexOf("(") + 1;
            int fin = l.indexOf(")");
            if (inicio > 0 && fin > inicio && (coords = (coordsTexto = l.substring(inicio, fin)).split(",")).length == 3) {
                try {
                    this.coordenadas[0] = Integer.parseInt(coords[0].trim());
                    this.coordenadas[1] = Integer.parseInt(coords[1].trim());
                    this.coordenadas[2] = Integer.parseInt(coords[2].trim());
                    this.coordenadasValidas = true;
                    this.actualizarMensajeSiCorresponde();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void actualizarMensajeSiCorresponde() {
        if (this.enlaceHtml == null) {
            return;
        }
        if (!this.nombreEntidad.isEmpty() || !this.tipoEntidad.isEmpty() || this.coordenadasValidas) {
            this.mensaje = MonitorDePID.idioma.mensajeTickingEntidadBloque(this.nombreEntidad, this.tipoEntidad, this.coordenadas) + " " + this.enlaceHtml;
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaTickingEntidadBloque();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaTickingEntidadBloque();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionEliminarEntidadBloque(this.nombreEntidad, this.coordenadas)).construir();
    }

    @Override
    public String id() {
        return "problema_ticking_entidad_bloque";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        String coordsTexto;
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (t.contains("Description: Ticking block entity")) {
            return true;
        }
        if (!this.tipoEntidad.isEmpty() && t.contains("Block entity being ticked") && t.contains(this.tipoEntidad)) {
            return true;
        }
        if (!this.nombreEntidad.isEmpty() && t.contains(this.nombreEntidad)) {
            return true;
        }
        return this.coordenadasValidas && t.contains(coordsTexto = "World: (" + this.coordenadas[0] + "," + this.coordenadas[1] + "," + this.coordenadas[2] + ")");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

