/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaTickingRegionalPlugin
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresPlugins = new ArrayList<String>();
    private final List<String> rutasPlugins = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("Could not load plugin '([^']+)'.*?in folder '([^']+)'.*?not marked as supporting regionised multithreading", 32);
        Matcher coincidencia = patron.matcher(contenido);
        while (coincidencia.find()) {
            String rutaCompleta = coincidencia.group(1);
            String carpeta = coincidencia.group(2);
            String nombrePlugin = this.extraerNombrePlugin(rutaCompleta);
            this.nombresPlugins.add(nombrePlugin);
            this.rutasPlugins.add(rutaCompleta);
        }
        if (!this.nombresPlugins.isEmpty()) {
            this.mensaje = this.nombresPlugins.size() > 1 ? MonitorDePID.idioma.mensajePluginTickingRegionalPlural(this.nombresPlugins) : MonitorDePID.idioma.mensajePluginTickingRegionalSingular(this.nombresPlugins.get(0));
            this.activado = true;
        }
    }

    private String extraerNombrePlugin(String ruta) {
        int indiceUltimaBarra = ruta.lastIndexOf("/");
        return indiceUltimaBarra != -1 ? ruta.substring(indiceUltimaBarra + 1) : ruta;
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaTickingRegionalPlugin();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaPluginTickingRegional();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.nombresPlugins.size(); ++i) {
            String nombre = this.nombresPlugins.get(i);
            String ruta = this.rutasPlugins.get(i);
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionDiferentePlugin(nombre));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(ruta));
        }
        builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarSoftwareSinTickingRegional("Paper"));
        return builder.construir();
    }

    @Override
    public String id() {
        return "ticking_regional_plugin";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

