/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaVersionAPIIncompatible
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresPlugins = new ArrayList<String>();
    private final List<String> versionesAPI = new ArrayList<String>();
    private static final Pattern PATRON_VIEJO = Pattern.compile("Could not load 'plugins[/\\\\]([^']+)' in folder '?([^']*)'?\\norg\\.bukkit\\.plugin\\.InvalidPluginException: Unsupported API version ([\\d\\.]+)", 32);
    private static final Pattern PATRON_NUEVO = Pattern.compile("Could not load plugin '((?!\\.jar).*\\.jar)' in folder '?([^']*)'?\\norg\\.bukkit\\.plugin\\.InvalidPluginException: Unsupported API version ([\\d\\.]+)", 32);
    private static final Pattern PATRON_PAPER_NUEVO = Pattern.compile("Could not load plugin '([^']+)' in folder.*?\\n.*?\\n.*?\\nPlugin API version ([\\d\\.]+) is lower than the minimum allowed version", 32);
    private static final Pattern PATRON_PAPER_MENSAJE = Pattern.compile("Could not load plugin '([^']+)' in folder.*?\\n.*?\\n.*?\\nPlugin API version ([\\d\\.]+) is not supported by this server", 32);
    private String pluginPendiente = null;
    private boolean esperandoVersionAPI = false;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        this.procesarCoincidenciasRegex(PATRON_VIEJO.matcher(contenido));
        this.procesarCoincidenciasRegex(PATRON_NUEVO.matcher(contenido));
        this.procesarCoincidenciasRegex(PATRON_PAPER_NUEVO.matcher(contenido));
        this.procesarCoincidenciasRegex(PATRON_PAPER_MENSAJE.matcher(contenido));
        this.reconstruirMensaje();
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea == null) {
            return;
        }
        String l = linea.trim();
        if (l.contains("Could not load plugin") && l.contains(".jar")) {
            String nombrePlugin;
            int inicioNombre = l.indexOf(39) + 1;
            int finNombre = l.indexOf(39, inicioNombre);
            if (inicioNombre > 0 && finNombre > inicioNombre && !(nombrePlugin = this.extraerNombrePlugin(l.substring(inicioNombre, finNombre))).isEmpty()) {
                this.pluginPendiente = nombrePlugin;
                this.esperandoVersionAPI = true;
            }
            return;
        }
        if (this.esperandoVersionAPI && l.contains("Plugin API version")) {
            int inicioVersion = l.indexOf("Plugin API version ") + "Plugin API version ".length();
            if (inicioVersion <= 0 || inicioVersion >= l.length()) {
                return;
            }
            int finVersion = l.indexOf(" ", inicioVersion);
            if (finVersion == -1) {
                finVersion = l.length();
            }
            String version = l.substring(inicioVersion, finVersion).trim();
            if (this.pluginPendiente != null && !this.pluginPendiente.isEmpty() && !version.isEmpty()) {
                this.nombresPlugins.add(this.pluginPendiente);
                this.versionesAPI.add(version);
                this.pluginPendiente = null;
                this.esperandoVersionAPI = false;
                this.reconstruirMensaje();
            }
        }
    }

    private void procesarCoincidenciasRegex(Matcher coincidencia) {
        while (coincidencia.find()) {
            if (coincidencia.groupCount() < 2) continue;
            this.nombresPlugins.add(this.extraerNombrePlugin(coincidencia.group(1)));
            this.versionesAPI.add(coincidencia.group(2));
        }
    }

    private void procesarFormatoPaperNuevo(Consola consola) {
    }

    private void procesarErrorPaper1206(String[] lineas, int indiceLinea) {
    }

    private void reconstruirMensaje() {
        if (this.nombresPlugins.isEmpty()) {
            this.mensaje = "";
            this.activado = false;
            return;
        }
        StringBuilder mensajeBuilder = new StringBuilder();
        for (int i = 0; i < this.nombresPlugins.size(); ++i) {
            mensajeBuilder.append(MonitorDePID.idioma.mensajeVersionAPIIncompatible(this.nombresPlugins.get(i), this.versionesAPI.get(i))).append("<br><br>");
        }
        this.mensaje = mensajeBuilder.toString();
        this.activado = true;
    }

    private String extraerNombrePlugin(String path) {
        int indiceUltimaBarra = path.lastIndexOf("/");
        return indiceUltimaBarra != -1 ? path.substring(indiceUltimaBarra + 1) : path;
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaVersionAPIIncompatible();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaVersionAPIIncompatible();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.nombresPlugins.size(); ++i) {
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarVersionServidor(this.versionesAPI.get(i)));
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionEliminarPlugin(this.nombresPlugins.get(i)));
        }
        return builder.construir();
    }

    @Override
    public String id() {
        return "problema_version_api_incompatible";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

