/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemaVersionModMundo
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private final List<String> nombresMods = new ArrayList<String>();
    private final List<String> versionesEsperadas = new ArrayList<String>();
    private final List<String> versionesActuales = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        Pattern patron = Pattern.compile("This world was saved with mod (\\w+) version (\\S+) and it is now at version ([^,]+), things may not work well", 2);
        Matcher coincidencia = patron.matcher(contenido);
        while (coincidencia.find()) {
            String nombreMod = coincidencia.group(1).trim();
            String versionEsperada = coincidencia.group(2).trim();
            String versionActual = coincidencia.group(3).trim();
            if (nombreMod.isEmpty() || versionEsperada.isEmpty() || versionActual.isEmpty()) continue;
            this.nombresMods.add(nombreMod);
            this.versionesEsperadas.add(versionEsperada);
            this.versionesActuales.add(versionActual);
        }
        if (!this.nombresMods.isEmpty()) {
            this.mensaje = this.nombresMods.size() > 1 ? MonitorDePID.idioma.mensajeVersionModMundoPlural(this.nombresMods, this.versionesEsperadas, this.versionesActuales) : MonitorDePID.idioma.mensajeVersionModMundoSingular(this.nombresMods.get(0), this.versionesEsperadas.get(0), this.versionesActuales.get(0));
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ProblemaVersionModMundo();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 800.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreProblemaVersionModMundo();
    }

    @Override
    public QuickFix solucion() {
        QuickFix.Builder builder = new QuickFix.Builder(this.nombre());
        for (int i = 0; i < this.nombresMods.size(); ++i) {
            String nombreMod = this.nombresMods.get(i);
            String versionEsperada = this.versionesEsperadas.get(i);
            builder.agregarEtiqueta(MonitorDePID.idioma.solucionInstalarModConVersion(nombreMod, versionEsperada));
        }
        return builder.construir();
    }

    @Override
    public boolean anularNormal() {
        return true;
    }

    @Override
    public String id() {
        return "version_mod_mundo";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

