/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class RailwaysCreate6Alfa
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String claveFaltante = "";
    private boolean tieneObjects = false;
    private boolean tieneRegistrate = false;

    @Override
    public void verificar(Consola consola) {
        String texto = consola.contenido_verificar;
        this.tieneObjects = texto.contains("at java.util.Objects.requireNonNull(");
        this.tieneRegistrate = texto.contains("at com.tterrag.registrate.util.entry.RegistryEntry.get(");
        if (!this.tieneObjects || !this.tieneRegistrate) {
            return;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || !this.tieneObjects || !this.tieneRegistrate || linea == null) {
            return;
        }
        if (linea.contains("java.lang.NullPointerException: Registry entry not present:")) {
            int idx = linea.indexOf("present:");
            if (idx >= 0) {
                this.claveFaltante = linea.substring(idx + "present:".length()).trim();
            }
            if (this.claveFaltante == null || this.claveFaltante.isEmpty()) {
                return;
            }
            this.mensaje = MonitorDePID.idioma.errorRailwaysCreate6Alfa(this.claveFaltante);
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new RailwaysCreate6Alfa();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        return this.activado ? this.mensaje + this.enlaceHtml : "";
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeRailwaysCreate6Alfa();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoRailwaysCreate6Alfa()).construir();
    }

    @Override
    public String id() {
        return "railways_6_alfa";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (t.contains("java.lang.NullPointerException: Registry entry not present:")) {
            return true;
        }
        return !this.claveFaltante.isEmpty() && t.contains("Registry entry not present:") && t.contains(this.claveFaltante) && t.contains("com.tterrag.registrate.util.entry.RegistryEntry.get(");
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

