/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegistrosMalMapeados
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> entradas = new HashSet<String>();

    @Override
    public void verificar(Consola consola) {
        String entrada2;
        String contenidoConsola = consola.contenido_verificar;
        Pattern patternFaltanIDs = Pattern.compile("Found a missing id from the world ([\\w\\d_:-]+:[\\w\\d_:-]+)");
        Pattern patternMapeoNoIdentificado = Pattern.compile("Unidentified mapping from registry [^:]+:([\\w\\d_:-]+:[\\w\\d_:-]+)");
        Pattern patternBloqueDensa = Pattern.compile("([\\w\\d_:-]+:[\\w\\d_:-]+)(?=:\\s*\\d+|$)");
        Matcher matcherFaltanIDs = patternFaltanIDs.matcher(contenidoConsola);
        Matcher matcherMapeoNoIdentificado = patternMapeoNoIdentificado.matcher(contenidoConsola);
        while (matcherFaltanIDs.find()) {
            entrada2 = matcherFaltanIDs.group(1).trim();
            if (!entrada2.contains(":")) continue;
            this.entradas.add(entrada2);
            this.activado = true;
        }
        while (matcherMapeoNoIdentificado.find()) {
            entrada2 = matcherMapeoNoIdentificado.group(1).trim();
            if (!entrada2.contains(":")) continue;
            this.entradas.add(entrada2);
            this.activado = true;
        }
        Pattern blockPattern = Pattern.compile("Unidentified mapping from registry [^:]+:([^$$]+)");
        Matcher blockMatcher = blockPattern.matcher(contenidoConsola);
        while (blockMatcher.find()) {
            String blockContent = blockMatcher.group(1);
            Matcher entryMatcher = patternBloqueDensa.matcher(blockContent);
            while (entryMatcher.find()) {
                String entrada3 = entryMatcher.group(1).trim();
                if (!entrada3.contains(":")) continue;
                this.entradas.add(entrada3);
                this.activado = true;
            }
        }
        this.entradas.removeIf(entrada -> entrada.matches(".*\\d{2}:\\d{2}:\\d{2}.*"));
    }

    @Override
    public Verificaciones nueva() {
        return new RegistrosMalMapeados();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        if (this.entradas.isEmpty()) {
            return "";
        }
        StringBuilder html = new StringBuilder();
        html.append("<b style='color:#" + Config.obtenerInstancia().obtenerColorError() + "'>" + MonitorDePID.idioma.solucionRegistrosMalMapeados() + "</b> ");
        html.append("<ul>");
        for (String entrada : this.entradas) {
            html.append("<li>").append(entrada).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_registros_mal_mapeados();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.solucionRegistrosMalMapeados()).construir();
    }

    @Override
    public boolean anularNormal() {
        return true;
    }

    @Override
    public String id() {
        return "registros_mal_mapeados";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

