/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class SCOErrorCompatibilidadC2ME
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private boolean c2mePresente = false;
    private boolean connectorPresente = false;
    private String enlaceHtml = "";

    @Override
    public void verificar(Consola consola) {
        String contenidoConsola = consola.contenido_verificar;
        if (contenidoConsola.contains("com.ishland.c2me")) {
            this.c2mePresente = true;
        }
        if (contenidoConsola.contains("SINYTRA CONNECTOR IS PRESENT!") || contenidoConsola.contains("specialcompatibilityoperation")) {
            this.connectorPresente = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || linea == null || !this.c2mePresente || !this.connectorPresente) {
            return;
        }
        if (linea.contains("java.lang.IllegalAccessException") && linea.contains("cannot access class jdk.internal.misc.Unsafe") && linea.contains("because module java.base does not export")) {
            this.mensaje = MonitorDePID.idioma.errorCompatibilidadC2ME() + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new SCOErrorCompatibilidadC2ME();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 945.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_error_compatibilidad_c2me();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1_compatibilidad_c2me()).agregarEtiqueta(MonitorDePID.idioma.paso2_compatibilidad_c2me()).agregarEtiqueta(MonitorDePID.idioma.paso3_compatibilidad_c2me()).construir();
    }

    @Override
    public String id() {
        return "sco_error_compatibilidad_c2me";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

