/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.CDStringBuilder;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServicioDeModLauncherNoFunciona
implements Verificaciones {
    private boolean activado = false;
    private final Set<String> serviciosFallidos = new HashSet<String>();
    private final Map<String, String> enlacesPorServicio = new HashMap<String, String>();
    private static final String CARGA_FALLIDA = "Service failed to load";

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (linea == null) {
            return;
        }
        if (linea.contains(CARGA_FALLIDA)) {
            String[] partes = linea.split(CARGA_FALLIDA, 2);
            String servicio = partes.length > 1 ? partes[1].trim() : "";
            String mensaje = MonitorDePID.idioma.servicioMLNoPudoCargar(servicio);
            if (this.serviciosFallidos.add(mensaje)) {
                String enlace = consola.agregarErrorALectador(numero_de_linea, this);
                this.enlacesPorServicio.put(mensaje, enlace);
            }
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new ServicioDeModLauncherNoFunciona();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1000.0f;
    }

    @Override
    public String mensaje() {
        if (this.serviciosFallidos.isEmpty()) {
            return "";
        }
        CDStringBuilder html = new CDStringBuilder();
        html.append("<ul>");
        for (String servicio : this.serviciosFallidos) {
            String enlace = this.enlacesPorServicio.getOrDefault(servicio, "");
            html.append("<li>").append(servicio).append(" ").append(enlace).append("</li>");
        }
        html.append("</ul>");
        return html.toString();
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombre_de_servicio_de_modlauncher_no_funciona();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public String id() {
        return "servicio_de_modlauncher_no_funciona";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

