/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;

public class TaczDeflaterCerrado
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private final List<String> modsUbicacion = new ArrayList<String>();
    private boolean tieneDeflaterCerradoEnLog = false;

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        this.tieneDeflaterCerradoEnLog = contenido.contains("Caused by: java.lang.NullPointerException: Deflater has been closed");
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || linea == null) {
            return;
        }
        if (!this.tieneDeflaterCerradoEnLog) {
            return;
        }
        if (linea.contains("at com.tacz.guns.util.GetJarResources.lambda$backupFiles$2")) {
            String classPath = "com/tacz/guns/util/GetJarResources.class";
            for (ArchivoDeMod mod : Buscardor.buscarModsConTermino(classPath)) {
                this.modsUbicacion.add(mod.ubicacion_para_publicar());
            }
            this.mensaje = MonitorDePID.idioma.errorTaczDeflaterCerrado(this.modsUbicacion) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new TaczDeflaterCerrado();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 950.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeTaczDeflaterCerrado();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.pasoTaczDeflaterCerrado()).construir();
    }

    @Override
    public String id() {
        return "tacz_deflater_cerrado";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!t.contains("NullPointerException: Deflater has been closed")) {
            return false;
        }
        return t.contains("com.tacz.guns.util.GetJarResources") && (t.contains("backupFiles") || t.contains("lambda$backupFiles$2"));
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

