/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class UraniumLag
implements Verificaciones {
    boolean activado = false;

    @Override
    public void verificar(Consola consola) {
        this.activado = Buscardor.existeClaseEnAlgunMod("net.yosa.uranium.Uranium");
    }

    @Override
    public Verificaciones nueva() {
        return new UraniumLag();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1400.0f;
    }

    @Override
    public String mensaje() {
        return MonitorDePID.idioma.uraniumLag();
    }

    @Override
    public String nombre() {
        return "UraniumLag";
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "uraniumlag";
    }

    @Override
    public Criticalidad nivel_de_criticalidad() {
        return Criticalidad.ADVERTENCIA;
    }

    @Override
    public boolean anularNormal() {
        return true;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

