/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.awt.Desktop;
import java.net.URI;

public class WaterMediaVLC
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";

    @Override
    public void verificar(Consola consola) {
        String contenido = consola.contenido_verificar;
        if (contenido.contains("WATERMeDIA doesn't contains VLC binaries for your OS and ARCH, you had to download it manually")) {
            this.mensaje = MonitorDePID.idioma.noTienesVLCBin() + "<br>";
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new WaterMediaVLC();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 700.0f;
    }

    @Override
    public String mensaje() {
        return this.mensaje;
    }

    @Override
    public String nombre() {
        return "WaterMediaVLC";
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder("WaterMediaVLC").agregarBoton(MonitorDePID.idioma.descargar_vlc(), retener -> {
            try {
                String url = "https://www.videolan.org/vlc/";
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    Desktop.getDesktop().browse(new URI(url));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }, true).construir();
    }

    @Override
    public Criticalidad nivel_de_criticalidad() {
        return Criticalidad.ADVERTENCIA;
    }

    @Override
    public String id() {
        return "watermedia_tl";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

