/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.apps.minecraft;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.buscar.ArchivoDeMod;
import com.asbestosstar.crashdetector.buscar.Buscardor;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import java.util.ArrayList;
import java.util.List;

public class WaterMediaXenonIncompatible
implements Verificaciones {
    private boolean activado = false;
    private String mensaje = "";
    private String enlaceHtml = "";
    private String modNombre = "";
    private String modId = "";
    private final List<String> modsUbicacion = new ArrayList<String>();

    @Override
    public void verificar(Consola consola) {
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.activado || linea == null) {
            return;
        }
        if (linea.contains("Failed starting WATERMeDIA for Forge") && linea.contains("is NOT compatible with WaterMedia")) {
            String termino;
            int forgeIdx = linea.indexOf("Forge:");
            if (forgeIdx >= 0) {
                int endName;
                int start = forgeIdx + "Forge: ".length();
                int open = linea.indexOf(40, start);
                int close = open >= 0 ? linea.indexOf(41, open + 1) : -1;
                int n = endName = open >= 0 ? open : linea.indexOf(" is NOT", start);
                if (endName > start) {
                    this.modNombre = linea.substring(start, endName).trim();
                }
                if (open >= 0 && close > open) {
                    this.modId = linea.substring(open + 1, close).trim();
                }
            }
            String string = termino = !this.modId.isEmpty() ? this.modId : this.modNombre;
            if (termino != null && !termino.isEmpty()) {
                try {
                    for (ArchivoDeMod m : Buscardor.buscarModsConTermino(termino)) {
                        this.modsUbicacion.add(m.ubicacion_para_publicar());
                    }
                }
                catch (Throwable t) {
                    CrashDetectorLogger.log("WaterMediaXenonIncompatible: fallo en b\u00fasqueda de mods: " + t.getMessage());
                }
            }
            this.mensaje = MonitorDePID.idioma.errorWaterMediaXenonIncompatible(this.modNombre.isEmpty() ? "(desconocido)" : this.modNombre, this.modId.isEmpty() ? "(desconocido)" : this.modId, this.modsUbicacion) + "<br>";
            this.enlaceHtml = consola.agregarErrorALectador(numero_de_linea, this);
            this.activado = true;
        }
    }

    @Override
    public Verificaciones nueva() {
        return new WaterMediaXenonIncompatible();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 900.0f;
    }

    @Override
    public String mensaje() {
        if (!this.activado) {
            return "";
        }
        return this.mensaje + this.enlaceHtml;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreDeWaterMediaXenonIncompatible();
    }

    @Override
    public QuickFix solucion() {
        return new QuickFix.Builder(this.nombre()).agregarEtiqueta(MonitorDePID.idioma.paso1WaterMediaXenonIncompatible(this.modNombre.isEmpty() ? "(desconocido)" : this.modNombre, this.modId.isEmpty() ? "(desconocido)" : this.modId)).agregarEtiqueta(MonitorDePID.idioma.paso2WaterMediaXenonIncompatible(this.modsUbicacion)).agregarEtiqueta(MonitorDePID.idioma.paso3WaterMediaXenonIncompatible()).construir();
    }

    @Override
    public String id() {
        return "watermedia_xenon";
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        if (!this.activado || trazo == null || trazo.trace == null) {
            return false;
        }
        String t = trazo.trace;
        if (!t.contains("Failed starting WATERMeDIA for Forge") || !t.contains("is NOT compatible with WaterMedia")) {
            return false;
        }
        if ((this.modNombre == null || this.modNombre.isEmpty()) && (this.modId == null || this.modId.isEmpty())) {
            return true;
        }
        if (this.modNombre != null && !this.modNombre.isEmpty() && t.contains(this.modNombre)) {
            return true;
        }
        if (this.modId != null && !this.modId.isEmpty() && t.contains(this.modId)) {
            return true;
        }
        return true;
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

