/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.firmas.v0;

import com.asbestosstar.crashdetector.CrashDetectorLogger;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.firmas.FiltrodeCodice;
import com.asbestosstar.crashdetector.analizador.firmas.v0.VerificacionFirmasV0;
import com.asbestosstar.crashdetector.json.Json;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class FirmasV0 {
    public static final int SCHEMA = 0;
    public static final String NOMBRE_ARCHIVO = "firmas.json";

    public static List<VerificacionFirmasV0> cargar() {
        ArrayList<VerificacionFirmasV0> lista;
        block23: {
            Path ruta = Statics.carpeta.resolve(NOMBRE_ARCHIVO);
            lista = new ArrayList<VerificacionFirmasV0>();
            try {
                int schema;
                if (!Files.exists(ruta, new LinkOption[0])) {
                    return lista;
                }
                byte[] bytes = Files.readAllBytes(ruta);
                String json = new String(bytes, StandardCharsets.UTF_8);
                Json.Nodo raiz = Json.leer(json);
                Json.Nodo nSchema = raiz != null ? raiz.obtener("schema") : null;
                try {
                    schema = nSchema == null ? 0 : nSchema.comoEntero();
                }
                catch (Throwable te) {
                    String sraw;
                    String string = sraw = nSchema == null ? null : nSchema.comoCadena();
                    if (sraw != null) {
                        try {
                            schema = Integer.parseInt(sraw.trim());
                        }
                        catch (NumberFormatException nfe) {
                            schema = 0;
                        }
                    }
                    schema = 0;
                }
                if (schema != 0) {
                    return lista;
                }
                Json.Nodo arr = raiz.obtener("verificaciones");
                if (arr != null) {
                    boolean esArr;
                    int tam = 0;
                    try {
                        esArr = arr.esArreglo();
                    }
                    catch (Throwable te) {
                        esArr = false;
                    }
                    try {
                        tam = arr.tamano();
                    }
                    catch (Throwable te) {
                        tam = 0;
                    }
                    if (tam > 0) {
                        for (int i = 0; i < tam; ++i) {
                            try {
                                Json.Nodo v = arr.en(i);
                                String id = FirmasV0.seguro(v.obtener("id"));
                                String para_buscar = FirmasV0.seguro(v.obtener("para_buscar"));
                                String idFiltro = FirmasV0.seguro(v.obtener("filtro"));
                                FiltrodeCodice filtro = FiltrodeCodice.obtener(idFiltro);
                                String critStr = FirmasV0.seguro(v.obtener("criticalidad"));
                                Criticalidad criticalidad = FirmasV0.parseCriticalidad(critStr);
                                int prioridad = 0;
                                Json.Nodo nPrio = v.obtener("prioridad");
                                if (nPrio != null) {
                                    try {
                                        prioridad = nPrio.comoEntero();
                                    }
                                    catch (Throwable te) {
                                        String pr = nPrio.comoCadena();
                                        try {
                                            prioridad = Integer.parseInt(pr.trim());
                                        }
                                        catch (Throwable ignore) {
                                            prioridad = 0;
                                        }
                                    }
                                }
                                Json.Nodo nombres = v.obtener("nombres");
                                String nombre_ar = FirmasV0.val(nombres, "ar");
                                String nombre_zh = FirmasV0.val(nombres, "zh");
                                String nombre_kp = FirmasV0.val(nombres, "kp");
                                String nombre_es = FirmasV0.val(nombres, "es");
                                String nombre_eo = FirmasV0.val(nombres, "eo");
                                String nombre_en = FirmasV0.val(nombres, "en");
                                String nombre_jp = FirmasV0.val(nombres, "jp");
                                String nombre_fa = FirmasV0.val(nombres, "fa");
                                String nombre_pt = FirmasV0.val(nombres, "pt");
                                String nombre_ru = FirmasV0.val(nombres, "ru");
                                Json.Nodo resultados = v.obtener("resultados");
                                String resultado_ar = FirmasV0.val(resultados, "ar");
                                String resultado_zh = FirmasV0.val(resultados, "zh");
                                String resultado_kp = FirmasV0.val(resultados, "kp");
                                String resultado_es = FirmasV0.val(resultados, "es");
                                String resultado_eo = FirmasV0.val(resultados, "eo");
                                String resultado_en = FirmasV0.val(resultados, "en");
                                String resultado_jp = FirmasV0.val(resultados, "jp");
                                String resultado_fa = FirmasV0.val(resultados, "fa");
                                String resultado_pt = FirmasV0.val(resultados, "pt");
                                String resultado_ru = FirmasV0.val(resultados, "ru");
                                VerificacionFirmasV0 ver = new VerificacionFirmasV0(id, nombre_ar, resultado_ar, nombre_zh, resultado_zh, nombre_kp, resultado_kp, nombre_es, resultado_es, nombre_eo, resultado_eo, nombre_en, resultado_en, nombre_jp, resultado_jp, nombre_fa, resultado_fa, nombre_pt, resultado_pt, nombre_ru, resultado_ru, criticalidad, prioridad, para_buscar, filtro);
                                lista.add(ver);
                                continue;
                            }
                            catch (Throwable ite) {
                                CrashDetectorLogger.log("[CodiceV0] ERROR en item i=" + i + ": " + ite.getClass().getName() + " - " + ite.getMessage());
                            }
                        }
                        break block23;
                    }
                    CrashDetectorLogger.log("[CodiceV0] 'verificaciones' sin elementos.");
                    break block23;
                }
                CrashDetectorLogger.log("[CodiceV0] 'verificaciones' es null.");
            }
            catch (Throwable t) {
                CrashDetectorLogger.log("[CodiceV0] EXCEPCI\u00d3N cargar(): " + t.getClass().getName() + " - " + t.getMessage());
            }
        }
        CrashDetectorLogger.log("[CodiceV0] retorno lista con size=" + lista.size());
        return lista;
    }

    public static void guardar(List<VerificacionFirmasV0> verificaciones) throws IOException {
        Path carpeta = Statics.carpeta;
        Path ruta = carpeta.resolve(NOMBRE_ARCHIVO);
        if (!Files.exists(carpeta, new LinkOption[0])) {
            Files.createDirectories(carpeta, new FileAttribute[0]);
        }
        Json.Nodo raiz = Json.crearObjeto();
        raiz.obtener("schema").poner(0);
        Json.Nodo arr = raiz.obtener("verificaciones");
        if (verificaciones != null) {
            for (VerificacionFirmasV0 v : verificaciones) {
                if (v == null) continue;
                Json.Nodo item = Json.crearObjeto();
                item.obtener("id").poner(FirmasV0.nz(v.id()));
                item.obtener("para_buscar").poner(FirmasV0.nz(v.para_buscar));
                item.obtener("filtro").poner(v.filtro != null ? FirmasV0.nz(v.filtro.id) : "");
                item.obtener("criticalidad").poner(v.criticalidad != null ? v.criticalidad.nombre : "ADVERTENCIA");
                item.obtener("prioridad").poner(v.prioridad);
                Json.Nodo nombres = Json.crearObjeto();
                nombres.obtener("ar").poner(FirmasV0.nz(v.nombre_ar));
                nombres.obtener("zh").poner(FirmasV0.nz(v.nombre_zh));
                nombres.obtener("kp").poner(FirmasV0.nz(v.nombre_kp));
                nombres.obtener("es").poner(FirmasV0.nz(v.nombre_es));
                nombres.obtener("eo").poner(FirmasV0.nz(v.nombre_eo));
                nombres.obtener("en").poner(FirmasV0.nz(v.nombre_en));
                nombres.obtener("jp").poner(FirmasV0.nz(v.nombre_jp));
                nombres.obtener("fa").poner(FirmasV0.nz(v.nombre_fa));
                nombres.obtener("pt").poner(FirmasV0.nz(v.nombre_pt));
                nombres.obtener("ru").poner(FirmasV0.nz(v.nombre_ru));
                item.obtener("nombres").poner(nombres);
                Json.Nodo resultados = Json.crearObjeto();
                resultados.obtener("ar").poner(FirmasV0.nz(v.resultado_ar));
                resultados.obtener("zh").poner(FirmasV0.nz(v.resultado_zh));
                resultados.obtener("kp").poner(FirmasV0.nz(v.resultado_kp));
                resultados.obtener("es").poner(FirmasV0.nz(v.resultado_es));
                resultados.obtener("eo").poner(FirmasV0.nz(v.resultado_eo));
                resultados.obtener("en").poner(FirmasV0.nz(v.resultado_en));
                resultados.obtener("jp").poner(FirmasV0.nz(v.resultado_jp));
                resultados.obtener("fa").poner(FirmasV0.nz(v.resultado_fa));
                resultados.obtener("pt").poner(FirmasV0.nz(v.resultado_pt));
                resultados.obtener("ru").poner(FirmasV0.nz(v.resultado_ru));
                item.obtener("resultados").poner(resultados);
                arr.agregar(item);
            }
        }
        String out = raiz.escribir();
        Files.write(ruta, out.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private static String val(Json.Nodo obj, String clave) {
        if (obj == null) {
            return "";
        }
        Json.Nodo n = obj.obtener(clave);
        return n == null ? "" : n.comoCadena();
    }

    private static String seguro(Json.Nodo n) {
        return n == null ? "" : n.comoCadena();
    }

    private static String nz(String s) {
        return s == null ? "" : s;
    }

    public static Criticalidad parseCriticalidad(String s) {
        if (s == null) {
            return Criticalidad.ADVERTENCIA;
        }
        String up = s.trim().toUpperCase();
        if ("ERROR".equals(up)) {
            return Criticalidad.ERROR;
        }
        if ("FATAL".equals(up)) {
            return Criticalidad.FATAL;
        }
        return Criticalidad.ADVERTENCIA;
    }

    public static class Builder {
        private final List<VerificacionFirmasV0> lista = new ArrayList<VerificacionFirmasV0>();

        public Builder agregar(VerificacionFirmasV0 v) {
            if (v != null) {
                this.lista.add(v);
            }
            return this;
        }

        public List<VerificacionFirmasV0> build() {
            return new ArrayList<VerificacionFirmasV0>(this.lista);
        }

        public void guardar() throws IOException {
            FirmasV0.guardar(this.lista);
        }
    }
}

