/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.firmas.v0;

import com.asbestosstar.crashdetector.Config;
import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.Idioma;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.Statics;
import com.asbestosstar.crashdetector.analizador.Criticalidad;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.analizador.firmas.FiltrodeCodice;
import com.asbestosstar.crashdetector.analizador.firmas.TipoDeFiltrodeCodice;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;
import com.asbestosstar.crashdetector.idioma.Arabe;
import com.asbestosstar.crashdetector.idioma.Chino;
import com.asbestosstar.crashdetector.idioma.Coreano;
import com.asbestosstar.crashdetector.idioma.Espanol;
import com.asbestosstar.crashdetector.idioma.Ingles;
import com.asbestosstar.crashdetector.idioma.Japones;
import com.asbestosstar.crashdetector.idioma.Persa;
import com.asbestosstar.crashdetector.idioma.Portuges;
import com.asbestosstar.crashdetector.idioma.Ruso;
import java.util.Objects;

public class VerificacionFirmasV0
implements Verificaciones {
    public String id;
    public String nombre_ar;
    public String resultado_ar;
    public String nombre_zh;
    public String resultado_zh;
    public String nombre_kp;
    public String resultado_kp;
    public String nombre_es;
    public String resultado_es;
    public String nombre_eo;
    public String resultado_eo;
    public String nombre_en;
    public String resultado_en;
    public String nombre_jp;
    public String resultado_jp;
    public String nombre_fa;
    public String resultado_fa;
    public String nombre_pt;
    public String resultado_pt;
    public String nombre_ru;
    public String resultado_ru;
    public Criticalidad criticalidad;
    public int prioridad;
    public String para_buscar;
    public FiltrodeCodice filtro;
    public boolean activado = false;
    public String enlace = "";

    public VerificacionFirmasV0(String id, String nombre_ar, String resultado_ar, String nombre_zh, String resultado_zh, String nombre_kp, String resultado_kp, String nombre_es, String resultado_es, String nombre_eo, String resultado_eo, String nombre_en, String resultado_en, String nombre_jp, String resultado_jp, String nombre_fa, String resultado_fa, String nombre_pt, String resultado_pt, String nombre_ru, String resultado_ru, Criticalidad criticalidad, int prioridad, String para_buscar, FiltrodeCodice filtro) {
        this.id = id;
        this.nombre_ar = nombre_ar;
        this.resultado_ar = resultado_ar;
        this.nombre_zh = nombre_zh;
        this.resultado_zh = resultado_zh;
        this.nombre_kp = nombre_kp;
        this.resultado_kp = resultado_kp;
        this.nombre_es = nombre_es;
        this.resultado_es = resultado_es;
        this.nombre_eo = nombre_eo;
        this.resultado_eo = resultado_eo;
        this.nombre_en = nombre_en;
        this.resultado_en = resultado_en;
        this.nombre_jp = nombre_jp;
        this.resultado_jp = resultado_jp;
        this.nombre_fa = nombre_fa;
        this.resultado_fa = resultado_fa;
        this.nombre_pt = nombre_pt;
        this.resultado_pt = resultado_pt;
        this.nombre_ru = nombre_ru;
        this.resultado_ru = resultado_ru;
        this.criticalidad = criticalidad;
        this.prioridad = prioridad;
        this.para_buscar = para_buscar;
        this.filtro = filtro;
    }

    @Override
    public void verificar(Consola consola) {
        if (this.filtro.tipo.equals(TipoDeFiltrodeCodice.DE_TODOS) && this.filtro.activar(consola.contenido_verificar, this.para_buscar)) {
            this.activado = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int numero_de_linea) {
        if (this.filtro.tipo.equals(TipoDeFiltrodeCodice.DE_LINEA) && this.filtro.activar(linea, this.para_buscar)) {
            this.activado = true;
            this.enlace = consola.agregarErrorALectador(numero_de_linea, this);
        }
    }

    @Override
    public Verificaciones nueva() {
        return new VerificacionFirmasV0(this.id, this.nombre_ar, this.resultado_ar, this.nombre_zh, this.resultado_zh, this.nombre_kp, this.resultado_kp, this.nombre_es, this.resultado_es, this.nombre_eo, this.resultado_eo, this.nombre_en, this.resultado_en, this.nombre_jp, this.resultado_jp, this.nombre_fa, this.resultado_fa, this.nombre_pt, this.resultado_pt, this.nombre_ru, this.resultado_ru, this.criticalidad, this.prioridad, this.para_buscar, this.filtro);
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return this.prioridad;
    }

    @Override
    public String mensaje() {
        return "<span style='color:#" + this.codigo_de_color() + "'>" + this.obtenerDesc() + "</span> " + this.enlace;
    }

    public String codigo_de_color() {
        if (this.criticalidad.equals(Criticalidad.ADVERTENCIA)) {
            return Config.obtenerInstancia().obtenerColorAdvertencia();
        }
        return Config.obtenerInstancia().obtenerColorAdvertencia();
    }

    public String obtenerDesc() {
        Idioma actual = MonitorDePID.idioma;
        if (actual.getClass().equals(Arabe.class)) {
            return this.resultado_ar;
        }
        if (actual.getClass().equals(Chino.class)) {
            return this.resultado_zh;
        }
        if (actual.getClass().equals(Coreano.class)) {
            return this.resultado_kp;
        }
        if (actual.getClass().equals(Espanol.class)) {
            return this.resultado_es;
        }
        if (actual.getClass().equals(Ingles.class)) {
            return this.resultado_en;
        }
        if (actual.getClass().equals(Japones.class)) {
            return this.resultado_jp;
        }
        if (actual.getClass().equals(Persa.class)) {
            return this.resultado_fa;
        }
        if (actual.getClass().equals(Portuges.class)) {
            return this.resultado_pt;
        }
        if (actual.getClass().equals(Ruso.class)) {
            return this.resultado_ru;
        }
        return this.resultado_es;
    }

    @Override
    public String nombre() {
        return this.obtenerNombre();
    }

    public String obtenerNombre() {
        Idioma actual = MonitorDePID.idioma;
        if (actual.getClass().equals(Arabe.class)) {
            return this.nombre_ar;
        }
        if (actual.getClass().equals(Chino.class)) {
            return this.nombre_zh;
        }
        if (actual.getClass().equals(Coreano.class)) {
            return this.nombre_kp;
        }
        if (actual.getClass().equals(Espanol.class)) {
            return this.nombre_es;
        }
        if (actual.getClass().equals(Ingles.class)) {
            return this.nombre_en;
        }
        if (actual.getClass().equals(Japones.class)) {
            return this.nombre_jp;
        }
        if (actual.getClass().equals(Persa.class)) {
            return this.nombre_fa;
        }
        if (actual.getClass().equals(Portuges.class)) {
            return this.nombre_pt;
        }
        if (actual.getClass().equals(Ruso.class)) {
            return this.nombre_ru;
        }
        return this.nombre_es;
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificacionFirmasV0 v = (VerificacionFirmasV0)o;
        return this.prioridad == v.prioridad && Objects.equals(this.id, v.id) && Objects.equals(this.para_buscar, v.para_buscar) && Objects.equals(this.filtro, v.filtro) && this.criticalidad == v.criticalidad && Objects.equals(this.nombre_es, v.nombre_es) && Objects.equals(this.resultado_es, v.resultado_es) && Objects.equals(this.nombre_en, v.nombre_en) && Objects.equals(this.resultado_en, v.resultado_en) && Objects.equals(this.nombre_ar, v.nombre_ar) && Objects.equals(this.resultado_ar, v.resultado_ar) && Objects.equals(this.nombre_pt, v.nombre_pt) && Objects.equals(this.resultado_pt, v.resultado_pt) && Objects.equals(this.nombre_fa, v.nombre_fa) && Objects.equals(this.resultado_fa, v.resultado_fa) && Objects.equals(this.nombre_ru, v.nombre_ru) && Objects.equals(this.resultado_ru, v.resultado_ru) && Objects.equals(this.nombre_zh, v.nombre_zh) && Objects.equals(this.resultado_zh, v.resultado_zh) && Objects.equals(this.nombre_eo, v.nombre_eo) && Objects.equals(this.resultado_eo, v.resultado_eo) && Objects.equals(this.nombre_jp, v.nombre_jp) && Objects.equals(this.resultado_jp, v.resultado_jp) && Objects.equals(this.nombre_kp, v.nombre_kp) && Objects.equals(this.resultado_kp, v.resultado_kp);
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return Statics.carpeta.resolve("firmas.json").toUri().toString();
    }

    @Override
    public boolean recomendadoParaCorperata() {
        return true;
    }
}

