/*
 * Decompiled with CFR 0.152.
 */
package com.asbestosstar.crashdetector.analizador.general;

import com.asbestosstar.crashdetector.Consola;
import com.asbestosstar.crashdetector.MonitorDePID;
import com.asbestosstar.crashdetector.analizador.QuickFix;
import com.asbestosstar.crashdetector.analizador.VerificacionDeStackTrace;
import com.asbestosstar.crashdetector.analizador.Verificaciones;
import com.asbestosstar.crashdetector.gui.tipos.docs.Documento;

public class AccesoDenegadoBackupConfig
implements Verificaciones {
    private boolean posibleErrorAcceso = false;
    private boolean activado = false;
    private String enlace = "";
    private String archivoOrigen = "";
    private String archivoBackup = "";

    @Override
    public void verificar(Consola consola) {
        if (consola.contenido_verificar.contains("java.nio.file.AccessDeniedException") && consola.contenido_verificar.contains("->")) {
            this.posibleErrorAcceso = true;
        }
    }

    @Override
    public void verificar(Consola consola, String linea, int num) {
        if (!this.posibleErrorAcceso) {
            return;
        }
        if (linea.contains("AccessDeniedException") && linea.contains("->")) {
            this.extraerRutas(linea);
            this.enlace = consola.agregarErrorALectador(num, this);
            this.activado = true;
        }
    }

    private void extraerRutas(String linea) {
        try {
            int idx = linea.indexOf("AccessDeniedException:");
            if (idx == -1) {
                return;
            }
            String rutas = linea.substring(idx + "AccessDeniedException:".length()).trim();
            String[] partes = rutas.split("->");
            if (partes.length >= 2) {
                this.archivoOrigen = partes[0].trim();
                this.archivoBackup = partes[1].trim();
            } else {
                this.archivoOrigen = rutas;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Verificaciones nueva() {
        return new AccesoDenegadoBackupConfig();
    }

    @Override
    public boolean activado() {
        return this.activado;
    }

    @Override
    public float prioridad() {
        return 1300.0f;
    }

    @Override
    public String mensaje() {
        return MonitorDePID.idioma.mensajeAccesoDenegadoBackupConfig(this.archivoOrigen, this.archivoBackup) + this.enlace;
    }

    @Override
    public String nombre() {
        return MonitorDePID.idioma.nombreAccesoDenegadoBackupConfig();
    }

    @Override
    public QuickFix solucion() {
        return QuickFix.NINGUN;
    }

    @Override
    public boolean ocupaTrazo(VerificacionDeStackTrace.TraceInfo trazo) {
        return false;
    }

    @Override
    public String id() {
        return "acceso_denegado_backup_config";
    }

    @Override
    public Documento docs() {
        return Documento.NINGUN;
    }

    @Override
    public String enlaceACodigo() {
        return "https://pagure.io/CrashDetectorMC/blob/main/f/src/main/java/com/asbestosstar/crashdetector/analizador/apps/minecraft/" + this.getClass().getSimpleName() + ".java";
    }
}

